/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.util.AnnotationValidatior;
import name.matthewgreet.strutscommons.util.DefaultAnnotationValidator;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnnotationValidationInterceptor2
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 2689404505465349761L;
    public static final int PARAM_NAME_MAX_LENGTH = 100;
    private Logger LOG = LogManager.getLogger(AnnotationValidationInterceptor2.class);
    @Inject(value="name.matthewgreet.strutscommons.accept_classes", required=false)
    private String acceptClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.accept_packages", required=false)
    private String acceptPackages = "";
    @Inject(value="name.matthewgreet.strutscommons.classpath_scanning_replace_built_in", required=false)
    private String classpathScanningReplaceBuiltIn = "false";
    @Inject(value="name.matthewgreet.strutscommons.enable_classpath_scanning", required=false)
    private String enableClassScanning = "false";
    @Inject(value="name.matthewgreet.strutscommons.reject_classes", required=false)
    private String rejectClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.reject_packages", required=false)
    private String rejectPackages = "";
    private Required.MessageType defaultMessageType = Required.MessageType.ERROR;
    private boolean disabled;
    private boolean ignoreNonAnnotatedFields = false;
    private int paramNameMaxLength = 100;

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled) {
            AnnotationValidatior annotationValidationLibrary = this.makeAnnotationValidationLibrary();
            annotationValidationLibrary.validate();
        }
        return invocation.invoke();
    }

    protected AnnotationValidatior makeAnnotationValidationLibrary() {
        PolicyLookup policyLookup = this.makePolicyLookup();
        DefaultAnnotationValidator result = new DefaultAnnotationValidator();
        result.setDefaultMessageType(this.getDefaultMessageType());
        result.setIgnoreNonAnnotatedFields(this.getIgnoreNonAnnotatedFields());
        result.setParamNameMaxLength(this.getParamNameMaxLength());
        result.setPolicyLookup(policyLookup);
        return result;
    }

    protected PolicyLookup makePolicyLookup() {
        DefaultPolicyLookup.Configuration configuration = new DefaultPolicyLookup.Configuration();
        configuration.setAcceptClasses(this.acceptClasses);
        configuration.setAcceptPackages(this.acceptPackages);
        configuration.setClasspathScanningReplaceBuiltIn(Boolean.parseBoolean(this.classpathScanningReplaceBuiltIn));
        configuration.setEnableClasspathScanning(Boolean.parseBoolean(this.enableClassScanning));
        configuration.setRejectClasses(this.rejectClasses);
        configuration.setRejectPackages(this.rejectPackages);
        return DefaultPolicyLookup.getInstance(configuration);
    }

    public Required.MessageType getDefaultMessageType() {
        return this.defaultMessageType;
    }

    public void setDefaultMessageType(Required.MessageType defaultMessageType) {
        if (defaultMessageType != null && defaultMessageType != Required.MessageType.DEFAULT) {
            this.defaultMessageType = defaultMessageType;
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getIgnoreNonAnnotatedFields() {
        return this.ignoreNonAnnotatedFields;
    }

    public void setIgnoreNonAnnotatedFields(boolean ignoreNonAnnotatedFields) {
        this.ignoreNonAnnotatedFields = ignoreNonAnnotatedFields;
    }

    public int getParamNameMaxLength() {
        return this.paramNameMaxLength;
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }
}

