/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import name.matthewgreet.strutscommons.action.LoggingAware;
import name.matthewgreet.strutscommons.action.ValidationAware2;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.Adjuster;
import name.matthewgreet.strutscommons.policy.CollectionConverter;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.CollectionPostConversionValidator;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.Converter;
import name.matthewgreet.strutscommons.policy.NonConversionValidator;
import name.matthewgreet.strutscommons.policy.PostConversionAdjuster;
import name.matthewgreet.strutscommons.policy.PostConversionValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class AnnotationValidationInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 2689404505465349761L;
    private Logger LOG = LogManager.getLogger(AnnotationValidationInterceptor.class);
    @Inject(value="name.matthewgreet.strutscommons.accept_classes", required=false)
    private String acceptClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.accept_packages", required=false)
    private String acceptPackages = "";
    @Inject(value="name.matthewgreet.strutscommons.classpath_scanning_replace_built_in", required=false)
    private String classpathScanningReplaceBuiltIn = "false";
    @Inject(value="name.matthewgreet.strutscommons.enable_classpath_scanning", required=false)
    private String enableClassScanning = "false";
    @Inject(value="name.matthewgreet.strutscommons.reject_classes", required=false)
    private String rejectClasses = "";
    @Inject(value="name.matthewgreet.strutscommons.reject_packages", required=false)
    private String rejectPackages = "";
    private boolean disabled;

    public static Collection<Field> getProperties(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private <T> void processFormField(ActionInvocation invocation, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger, Collection<Field> allFormFields, Field formField, Object form, boolean modelDriven) throws Exception {
        boolean shortCircuit;
        ValidationResult validationResult;
        formField.setAccessible(true);
        String fieldName = formField.getName();
        String fieldValue = (String)formField.get(form);
        if (fieldValue == null) {
            fieldValue = "";
            formField.set(form, fieldValue);
        }
        ArrayList<AnnotationEntry<T>> adjusterAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        ArrayList<AnnotationEntry<T>> collectionPostConversionAdjusterAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        ArrayList<AnnotationEntry<T>> collectionPostConversionValidatorAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        ArrayList<AnnotationEntry<T>> nonConversionAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        ArrayList<AnnotationEntry<T>> postConversionAdjusterAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        ArrayList<AnnotationEntry<T>> postConversionValidatorAnnotationEntries = new ArrayList<AnnotationEntry<T>>();
        AnnotationEntry<T> conversionAnnotationEntry = null;
        AnnotationEntry<T> collectionConversionAnnotationEntry = null;
        Annotation[] annotations = formField.getAnnotations();
        block15: for (Annotation annotation : annotations) {
            InterceptorCommonLibrary.ConfiguredPolicy<T> configuredPolicy;
            try {
                configuredPolicy = this.getConfiguredPolicy(formField, annotation);
            }
            catch (Exception e) {
                configuredPolicy = InterceptorCommonLibrary.ConfiguredPolicy.makeNAResult(annotation);
                this.LOG.error("Client supplied validator for form field failed   Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  annotation=" + annotation.annotationType(), (Throwable)e);
            }
            switch (configuredPolicy.getAnnotationUsage()) {
                case ADJUSTER: {
                    adjusterAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                    continue block15;
                }
                case COLLECTION_CONVERT: {
                    collectionConversionAnnotationEntry = new AnnotationEntry<T>(annotation, configuredPolicy);
                    continue block15;
                }
                case COLLECTION_POST_ADJUSTER: {
                    collectionPostConversionAdjusterAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                    continue block15;
                }
                case COLLECTION_POST_VALIDATION: {
                    collectionPostConversionValidatorAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                    continue block15;
                }
                case CONVERT: {
                    conversionAnnotationEntry = new AnnotationEntry<T>(annotation, configuredPolicy);
                    continue block15;
                }
                case FORM_FIELD: {
                    continue block15;
                }
                case MANUAL_PARAMETER_CONVERSION: {
                    continue block15;
                }
                case NA: {
                    continue block15;
                }
                case NON_CONVERT_VALIDATION: {
                    nonConversionAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                    continue block15;
                }
                case POST_ADJUSTER: {
                    postConversionAdjusterAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                    continue block15;
                }
                case POST_VALIDATION: {
                    postConversionValidatorAnnotationEntries.add(new AnnotationEntry<T>(annotation, configuredPolicy));
                }
            }
        }
        for (AnnotationEntry annotationEntry : adjusterAnnotationEntries) {
            Adjuster<?> adjuster = annotationEntry.getConfiguredPolicy().getAdjuster();
            fieldValue = this.adjust(form, formField, annotationEntry.getAnnotation(), adjuster, fieldValue);
        }
        boolean rejected = false;
        for (AnnotationEntry annotationEntry : nonConversionAnnotationEntries) {
            NonConversionValidator<?> nonConversionValidator = annotationEntry.getConfiguredPolicy().getNonConversionValidator();
            validationResult = this.validateNonConversion(formField, annotationEntry, fieldValue);
            if (!validationResult.getSuccess()) {
                rejected = true;
                shortCircuit = this.getNonConversionShortCircuit(formField, annotationEntry, fieldValue);
            } else {
                shortCircuit = false;
            }
            this.checkNonConversionMessage(formField, annotationEntry.getAnnotation(), nonConversionValidator, validationResult, validationAware, textProvider, validationLogger);
            if (!shortCircuit) continue;
            break;
        }
        if (!rejected && conversionAnnotationEntry != null) {
            ConversionFieldResult<T> conversionFieldResult = this.convert(invocation, form, allFormFields, formField, fieldName, fieldValue, conversionAnnotationEntry, modelDriven);
            if (conversionFieldResult != null) {
                Converter<?, T> converter = conversionAnnotationEntry.getConfiguredPolicy().getConverter();
                Field recipientField = conversionFieldResult.getRecipeintField();
                ConversionResult<T> conversionResult = conversionFieldResult.getConversionResult();
                T parsedValue = conversionResult.getParsedValue();
                this.checkConversionMessage(formField, conversionAnnotationEntry.getAnnotation(), converter, conversionFieldResult, validationAware, textProvider, validationLogger);
                for (AnnotationEntry annotationEntry : postConversionAdjusterAnnotationEntries) {
                    parsedValue = this.postConvertAdjust(invocation, form, formField, recipientField, conversionResult, parsedValue, annotationEntry, modelDriven);
                }
                for (AnnotationEntry annotationEntry : postConversionValidatorAnnotationEntries) {
                    validationResult = this.postConvertValidate(invocation, form, formField, recipientField, conversionResult, parsedValue, annotationEntry, modelDriven);
                    if (validationResult != null) {
                        PostConversionValidator postConversionValidator = annotationEntry.getConfiguredPolicy().getPostConversionValidator();
                        if (!validationResult.getSuccess()) {
                            rejected = true;
                            shortCircuit = this.getPostConversionShortCircuit(formField, annotationEntry, parsedValue);
                        } else {
                            shortCircuit = false;
                        }
                        this.checkPostConversionMessage(formField, annotationEntry.getAnnotation(), postConversionValidator, conversionFieldResult, validationResult, validationAware, textProvider, validationLogger);
                    } else {
                        shortCircuit = false;
                    }
                    if (!shortCircuit) continue;
                    break;
                }
            } else {
                rejected = true;
            }
        } else if (!rejected && collectionConversionAnnotationEntry != null) {
            ConversionFieldResult<T> conversionFieldResult = this.collectionConvert(invocation, form, allFormFields, formField, fieldName, fieldValue, collectionConversionAnnotationEntry, modelDriven);
            if (conversionFieldResult != null) {
                CollectionConverter<?, T> collectionConverter = collectionConversionAnnotationEntry.getConfiguredPolicy().getCollectionConverter();
                Field recipientField = conversionFieldResult.getRecipeintField();
                ConversionResult<T> conversionResult = conversionFieldResult.getConversionResult();
                Collection<T> parsedCollectionValue = conversionResult.getParsedCollectionValue();
                this.checkCollectionConversionMessage(formField, collectionConversionAnnotationEntry.getAnnotation(), collectionConverter, conversionFieldResult, validationAware, textProvider, validationLogger);
                for (AnnotationEntry annotationEntry : collectionPostConversionAdjusterAnnotationEntries) {
                    parsedCollectionValue = this.collectionPostConvertAdjust(invocation, form, formField, recipientField, conversionResult, parsedCollectionValue, annotationEntry, modelDriven);
                }
                for (AnnotationEntry annotationEntry : collectionPostConversionValidatorAnnotationEntries) {
                    validationResult = this.collectionPostConvertValidate(invocation, form, formField, recipientField, conversionResult, parsedCollectionValue, annotationEntry, modelDriven);
                    if (validationResult != null) {
                        CollectionPostConversionValidator collectionPostConversionValidator = annotationEntry.getConfiguredPolicy().getCollectionPostConversionValidator();
                        if (!validationResult.getSuccess()) {
                            rejected = true;
                            shortCircuit = this.getCollectionPostConversionShortCircuit(formField, annotationEntry, parsedCollectionValue);
                        } else {
                            shortCircuit = false;
                        }
                        this.checkCollectionPostConversionMessage(formField, annotationEntry.getAnnotation(), collectionPostConversionValidator, conversionFieldResult, validationResult, validationAware, textProvider, validationLogger);
                    } else {
                        shortCircuit = false;
                    }
                    if (!shortCircuit) continue;
                    break;
                }
            } else {
                rejected = true;
            }
        }
    }

    protected String adjust(Object form, Field formField, Annotation annotation, Adjuster<?> adjuster, String fieldValue) throws Exception {
        if (fieldValue.length() > 0 || adjuster.getProcessNoValue()) {
            fieldValue = adjuster.adjust(fieldValue);
            formField.set(form, fieldValue);
        }
        return fieldValue;
    }

    protected <T> void checkCollectionConversionMessage(Field unconvertedField, Annotation annotation, CollectionConverter<?, T> collectionConverter, ConversionFieldResult<T> conversionFieldResult, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger) {
        if (!conversionFieldResult.getConversionResult().getSuccess()) {
            String message = conversionFieldResult.getConversionResult().getMessage() != null ? conversionFieldResult.getConversionResult().getMessage() : collectionConverter.getMessage();
            String messageKey = conversionFieldResult.getConversionResult().getMessageKey() != null ? conversionFieldResult.getConversionResult().getMessageKey() : collectionConverter.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = conversionFieldResult.getConversionResult().getMessageType() != null ? conversionFieldResult.getConversionResult().getMessageType() : collectionConverter.getMessageType();
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, unconvertedField.getName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(validationLogger, finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected boolean checkCollectionConversionRecipientDataType(Field unconvertedField, Annotation annotation, Field recipientField, Class<?> recipientClass) {
        return InterceptorCommonLibrary.checkCollectionRecipientDataType(recipientField, recipientClass);
    }

    protected <T> void checkCollectionPostConversionMessage(Field unconvertedField, Annotation annotation, CollectionPostConversionValidator<?, T> collectionPostConversionValidator, ConversionFieldResult<T> conversionFieldResult, ValidationResult validationResult, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger) {
        if (!validationResult.getSuccess()) {
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : collectionPostConversionValidator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : collectionPostConversionValidator.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : collectionPostConversionValidator.getMessageType();
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, unconvertedField.getName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(validationLogger, finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected boolean checkCollectionPostConversionRecipientDataType(Annotation annotation, Field recipientField, Class<?> recipientClass) {
        return InterceptorCommonLibrary.checkCollectionRecipientDataType(recipientField, recipientClass);
    }

    protected <T> void checkConversionMessage(Field unconvertedField, Annotation annotation, Converter<?, T> converter, ConversionFieldResult<T> conversionFieldResult, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger) {
        if (!conversionFieldResult.getConversionResult().getSuccess()) {
            String message = conversionFieldResult.getConversionResult().getMessage() != null ? conversionFieldResult.getConversionResult().getMessage() : converter.getMessage();
            String messageKey = conversionFieldResult.getConversionResult().getMessageKey() != null ? conversionFieldResult.getConversionResult().getMessageKey() : converter.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = conversionFieldResult.getConversionResult().getMessageType() != null ? conversionFieldResult.getConversionResult().getMessageType() : converter.getMessageType();
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, unconvertedField.getName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(validationLogger, finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected boolean checkConversionRecipientDataType(Field unconvertedField, Annotation annotation, Field recipientField, Class<?> recipientClass) {
        return InterceptorCommonLibrary.checkRecipientDataType(recipientField, recipientClass);
    }

    protected void checkNonConversionMessage(Field unconvertedField, Annotation annotation, NonConversionValidator<?> validator, ValidationResult validationResult, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger) {
        if (!validationResult.getSuccess()) {
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : validator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : validator.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : validator.getMessageType();
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, unconvertedField.getName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(validationLogger, finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected boolean checkPostConversionRecipientDataType(Annotation annotation, Field recipientField, Class<?> recipientClass) {
        return InterceptorCommonLibrary.checkRecipientDataType(recipientField, recipientClass);
    }

    protected <T> void checkPostConversionMessage(Field unconvertedField, Annotation annotation, PostConversionValidator<?, T> postConversionValidator, ConversionFieldResult<T> conversionFieldResult, ValidationResult validationResult, ValidationAware validationAware, TextProvider textProvider, Logger validationLogger) {
        if (!validationResult.getSuccess()) {
            String message = validationResult.getMessage() != null ? validationResult.getMessage() : postConversionValidator.getMessage();
            String messageKey = validationResult.getMessageKey() != null ? validationResult.getMessageKey() : postConversionValidator.getMessageKey();
            String finalMessage = this.getMessage(textProvider, messageKey, message);
            Required.MessageType messageType = validationResult.getMessageType() != null ? validationResult.getMessageType() : postConversionValidator.getMessageType();
            switch (messageType) {
                case ERROR: {
                    this.writeGeneralError(validationAware, finalMessage);
                    break;
                }
                case FIELD: {
                    this.writeFieldError(validationAware, unconvertedField.getName(), finalMessage);
                    break;
                }
                case DEFAULT: 
                case IGNORE: {
                    this.ignoreMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_DEBUG: {
                    this.logDebugMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_ERROR: {
                    this.logErrorMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_INFO: {
                    this.logInfoMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_TRACE: {
                    this.logTraceMessage(validationLogger, finalMessage);
                    break;
                }
                case LOG_WARN: {
                    this.logWarnMessage(validationLogger, finalMessage);
                    break;
                }
                case MESSAGE: {
                    this.writeInfoMessage(validationAware, finalMessage);
                    break;
                }
                case WARNING: {
                    this.writeWarningMessage(validationAware, finalMessage);
                }
            }
        }
    }

    protected <T> ConversionFieldResult<T> collectionConvert(ActionInvocation invocation, Object form, Collection<Field> allFormFields, Field formField, String fieldName, String fieldValue, AnnotationEntry<T> collectionConversionAnnotationEntry, boolean modelDriven) {
        Field recipientField;
        Annotation colectionConversionAnnotation = collectionConversionAnnotationEntry.getAnnotation();
        CollectionConverter<?, T> collectionConverter = collectionConversionAnnotationEntry.getConfiguredPolicy().getCollectionConverter();
        String recipientFieldName = collectionConverter.getRecipientFieldName();
        if (recipientFieldName == null || recipientFieldName.length() == 0) {
            recipientFieldName = this.getDefaultRecipientName(formField, fieldName);
        }
        if ((recipientField = this.getRecipientField(formField, colectionConversionAnnotation, allFormFields, recipientFieldName)) == null) {
            this.LOG.error("Form field annotation refers to non-existent recipient field, explicitly or by default  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  annotation=" + colectionConversionAnnotation.annotationType());
            return null;
        }
        boolean compatible = this.checkCollectionConversionRecipientDataType(formField, colectionConversionAnnotation, recipientField, collectionConverter.getRecipientClass());
        if (!compatible) {
            this.LOG.error("Recipient field cannot receive converted value  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + colectionConversionAnnotation.annotationType() + "  allowed classes=" + collectionConverter.getRecipientClass());
            return null;
        }
        if (fieldValue.length() > 0 || collectionConverter.getProcessNoValue()) {
            ConversionResult<T> validationResult;
            Collection<T> parsedValue = null;
            try {
                Class recipientFieldClass = InterceptorCommonLibrary.getTypeFromCollectionField(recipientField);
                validationResult = this.validateCollectionConversion(formField, colectionConversionAnnotation, collectionConverter, fieldValue, recipientField, recipientFieldClass);
                parsedValue = validationResult.getParsedCollectionValue();
                if (validationResult.getSuccess() && parsedValue != null) {
                    recipientField.setAccessible(true);
                    recipientField.set(form, parsedValue);
                }
            }
            catch (Exception e) {
                this.LOG.error("Setting recipient field failed  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  annotation=" + colectionConversionAnnotation.annotationType() + "  value to set=" + parsedValue, (Throwable)e);
                validationResult = ConversionResult.makeFailureResult();
            }
            ConversionFieldResult<T> result = new ConversionFieldResult<T>(recipientField, validationResult);
            return result;
        }
        return new ConversionFieldResult(recipientField, ConversionResult.makeSkippedResult());
    }

    protected <T> Collection<T> collectionPostConvertAdjust(ActionInvocation invocation, Object form, Field formField, Field recipientField, ConversionResult<T> conversionResult, Collection<T> parsedCollectionValue, AnnotationEntry<T> collectionPostConversionAdjusterAnnotationEntry, boolean modelDriven) throws Exception {
        Annotation postConversionAnnotation = collectionPostConversionAdjusterAnnotationEntry.getAnnotation();
        CollectionPostConversionAdjuster<?, T> collectionPostConversionAdjuster = collectionPostConversionAdjusterAnnotationEntry.getConfiguredPolicy().getCollectionPostConversionAdjuster();
        Collection<T> result = parsedCollectionValue;
        if (conversionResult.getSuccess() && parsedCollectionValue != null || collectionPostConversionAdjuster.getProcessNoValue()) {
            boolean compatible = this.checkPostConversionRecipientDataType(postConversionAnnotation, recipientField, collectionPostConversionAdjuster.getRecipientClass());
            if (!compatible) {
                this.LOG.warn("Collection post conversion adjuster has incompatible data type for recipient field  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + postConversionAnnotation.annotationType() + "  allowed classes=" + collectionPostConversionAdjuster.getRecipientClass());
                result = parsedCollectionValue;
            }
            result = collectionPostConversionAdjuster.adjust(parsedCollectionValue);
        }
        return result;
    }

    protected <T> ValidationResult collectionPostConvertValidate(ActionInvocation invocation, Object form, Field formField, Field recipientField, ConversionResult<T> conversionResult, Collection<T> parsedValue, AnnotationEntry<T> postConversionAnnotationEntry, boolean modelDriven) throws Exception {
        Annotation postConversionAnnotation = postConversionAnnotationEntry.getAnnotation();
        CollectionPostConversionValidator<?, T> collectionPostConversionValidator = postConversionAnnotationEntry.getConfiguredPolicy().getCollectionPostConversionValidator();
        if (conversionResult.getSuccess() && parsedValue != null || collectionPostConversionValidator.getProcessNoValue()) {
            boolean compatible = this.checkCollectionPostConversionRecipientDataType(postConversionAnnotation, recipientField, collectionPostConversionValidator.getRecipientClass());
            if (!compatible) {
                this.LOG.error("Post conversion validator has incompatible data type for recipient field  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + postConversionAnnotation.annotationType() + "  allowed class=" + collectionPostConversionValidator.getRecipientClass());
                return null;
            }
            Class recipientFieldClass = InterceptorCommonLibrary.getTypeFromCollectionField(recipientField);
            ValidationResult result = this.validateCollectionPostConversion(formField, postConversionAnnotationEntry.getAnnotation(), postConversionAnnotationEntry.getConfiguredPolicy().getCollectionPostConversionValidator(), parsedValue, recipientField, recipientFieldClass);
            return result;
        }
        return ValidationResult.makeSuccessResult();
    }

    protected <T> ConversionFieldResult<T> convert(ActionInvocation invocation, Object form, Collection<Field> allFormFields, Field formField, String fieldName, String fieldValue, AnnotationEntry<T> conversionAnnotationEntry, boolean modelDriven) {
        Field recipientField;
        Annotation conversionAnnotation = conversionAnnotationEntry.getAnnotation();
        Converter<?, T> converter = conversionAnnotationEntry.getConfiguredPolicy().getConverter();
        String recipientFieldName = converter.getRecipientFieldName();
        if (recipientFieldName == null || recipientFieldName.length() == 0) {
            recipientFieldName = this.getDefaultRecipientName(formField, fieldName);
        }
        if ((recipientField = this.getRecipientField(formField, conversionAnnotation, allFormFields, recipientFieldName)) == null) {
            this.LOG.error("Form field annotation refers to non-existent recipient field, explicitly or by default  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  annotation=" + conversionAnnotation.annotationType());
            return null;
        }
        boolean compatible = this.checkConversionRecipientDataType(formField, conversionAnnotation, recipientField, converter.getRecipientClass());
        if (!compatible) {
            this.LOG.error("Recipient field cannot receive converted value  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + conversionAnnotation.annotationType() + "  allowed classes=" + converter.getRecipientClass());
            return null;
        }
        if (fieldValue.length() > 0 || converter.getProcessNoValue()) {
            ConversionResult<T> conversionResult;
            Object parsedValue = null;
            try {
                conversionResult = this.validateConversion(formField, conversionAnnotation, converter, fieldValue, recipientField, recipientField.getType());
                parsedValue = conversionResult.getParsedValue();
                if (conversionResult.getSuccess() && parsedValue != null) {
                    recipientField.setAccessible(true);
                    recipientField.set(form, parsedValue);
                }
            }
            catch (Exception e) {
                this.LOG.error("Setting recipient field failed  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  annotation=" + conversionAnnotation.annotationType() + "  value to set=" + parsedValue, (Throwable)e);
                conversionResult = ConversionResult.makeFailureResult();
            }
            ConversionFieldResult<T> result = new ConversionFieldResult<T>(recipientField, conversionResult);
            return result;
        }
        return new ConversionFieldResult(recipientField, ConversionResult.makeSkippedResult());
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled) {
            Object action = invocation.getAction();
            boolean modelDriven = action instanceof ModelDriven;
            Object form = modelDriven ? ((ModelDriven)action).getModel() : action;
            TextProvider textProvider = action instanceof TextProvider ? (TextProvider)action : null;
            ValidationAware validationAware = action instanceof ValidationAware ? (ValidationAware)action : null;
            Logger validationLogger = action instanceof LoggingAware ? ((LoggingAware)action).getLogger() : this.LOG;
            Collection<Field> allFormFields = AnnotationValidationInterceptor.getProperties(form.getClass());
            for (Field formField : allFormFields) {
                if (!formField.getType().isAssignableFrom(String.class)) continue;
                this.processFormField(invocation, validationAware, textProvider, validationLogger, allFormFields, formField, form, modelDriven);
            }
        }
        return invocation.invoke();
    }

    protected <T> InterceptorCommonLibrary.ConfiguredPolicy<T> getConfiguredPolicy(Field unconvertedField, Annotation annotation) throws Exception {
        DefaultPolicyLookup.Configuration configuration = new DefaultPolicyLookup.Configuration();
        configuration.setAcceptClasses(this.acceptClasses);
        configuration.setAcceptPackages(this.acceptPackages);
        configuration.setClasspathScanningReplaceBuiltIn(Boolean.parseBoolean(this.classpathScanningReplaceBuiltIn));
        configuration.setEnableClasspathScanning(Boolean.parseBoolean(this.enableClassScanning));
        configuration.setRejectClasses(this.rejectClasses);
        configuration.setRejectPackages(this.rejectPackages);
        DefaultPolicyLookup defaultPolicyLookup = DefaultPolicyLookup.getInstance(configuration);
        return InterceptorCommonLibrary.getConfiguredPolicy(annotation, defaultPolicyLookup);
    }

    protected <T> boolean getCollectionPostConversionShortCircuit(Field unconvertedField, AnnotationEntry<?> annotationEntry, Collection<T> parsedValue) {
        return annotationEntry.getConfiguredPolicy().getCollectionPostConversionValidator().getShortCircuit();
    }

    protected String getDefaultRecipientName(Field unconvertedField, String fieldName) {
        return InterceptorCommonLibrary.getDefaultRecipientName(fieldName);
    }

    protected String getMessage(TextProvider textProvider, String messageKey, String message) {
        String result = textProvider != null && messageKey != null && messageKey.length() > 0 && textProvider.hasKey(messageKey) ? textProvider.getText(messageKey) : message;
        return result;
    }

    protected boolean getNonConversionShortCircuit(Field unconvertedField, AnnotationEntry<?> annotationEntry, String formValue) {
        return annotationEntry.getConfiguredPolicy().getNonConversionValidator().getShortCircuit();
    }

    protected <T> boolean getPostConversionShortCircuit(Field unconvertedField, AnnotationEntry<?> annotationEntry, T parsedValue) {
        return annotationEntry.getConfiguredPolicy().getPostConversionValidator().getShortCircuit();
    }

    protected Field getRecipientField(Field unconvertedField, Annotation annotation, Collection<Field> fields, String recipientFieldName) {
        Field result = null;
        for (Field field : fields) {
            if (!field.getName().equals(recipientFieldName)) continue;
            result = field;
            break;
        }
        return result;
    }

    protected void ignoreMessage(Logger logger, String message) {
    }

    protected void logDebugMessage(Logger validationLogger, String message) {
        if (validationLogger.isDebugEnabled()) {
            validationLogger.debug(message);
        }
    }

    protected void logErrorMessage(Logger validationLogger, String message) {
        if (validationLogger.isErrorEnabled()) {
            validationLogger.error(message);
        }
    }

    protected void logInfoMessage(Logger validationLogger, String message) {
        if (validationLogger.isInfoEnabled()) {
            validationLogger.info(message);
        }
    }

    protected void logTraceMessage(Logger validationLogger, String message) {
        if (validationLogger.isTraceEnabled()) {
            validationLogger.trace(message);
        }
    }

    protected void logWarnMessage(Logger validationLogger, String message) {
        if (validationLogger.isWarnEnabled()) {
            validationLogger.warn(message);
        }
    }

    protected <T> Collection<T> makeCollectionForRecipient(Class<?> recipientFieldClass) {
        return InterceptorCommonLibrary.makeCollectionForRecipient(recipientFieldClass);
    }

    protected <T> T postConvertAdjust(ActionInvocation invocation, Object form, Field formField, Field recipientField, ConversionResult<T> conversionResult, T parsedValue, AnnotationEntry<T> postConversionAnnotationEntry, boolean modelDriven) throws Exception {
        Annotation postConversionAnnotation = postConversionAnnotationEntry.getAnnotation();
        PostConversionAdjuster<?, T> postConversionAdjuster = postConversionAnnotationEntry.getConfiguredPolicy().getPostConversionAdjuster();
        T result = parsedValue;
        if (conversionResult.getSuccess() && parsedValue != null || postConversionAdjuster.getProcessNoValue()) {
            boolean compatible = this.checkPostConversionRecipientDataType(postConversionAnnotation, recipientField, postConversionAdjuster.getRecipientClass());
            if (!compatible) {
                this.LOG.warn("Post conversion adjuster has incompatible data type for recipient field  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + postConversionAnnotation.annotationType() + "  allowed classes=" + postConversionAdjuster.getRecipientClass());
                result = parsedValue;
            }
            result = postConversionAdjuster.adjust(parsedValue);
        }
        return result;
    }

    protected <T> ValidationResult postConvertValidate(ActionInvocation invocation, Object form, Field formField, Field recipientField, ConversionResult<T> conversionResult, T parsedValue, AnnotationEntry<T> postConversionAnnotationEntry, boolean modelDriven) throws Exception {
        Annotation postConversionAnnotation = postConversionAnnotationEntry.getAnnotation();
        PostConversionValidator<?, T> postConversionValidator = postConversionAnnotationEntry.getConfiguredPolicy().getPostConversionValidator();
        if (conversionResult.getSuccess() && parsedValue != null || postConversionValidator.getProcessNoValue()) {
            boolean compatible = this.checkPostConversionRecipientDataType(postConversionAnnotation, recipientField, postConversionValidator.getRecipientClass());
            if (!compatible) {
                this.LOG.error("Post conversion validator has incompatible data type for recipient field  Struts action=" + invocation.getAction().getClass() + "  model driven=" + modelDriven + "  field=" + formField.getName() + "  recipient field=" + recipientField.getName() + "  annotation=" + postConversionAnnotation.annotationType() + "  allowed classes=" + postConversionValidator.getRecipientClass());
                return null;
            }
            ValidationResult result = this.validatePostConversion(formField, postConversionAnnotationEntry.getAnnotation(), postConversionAnnotationEntry.getConfiguredPolicy().getPostConversionValidator(), parsedValue, recipientField, recipientField.getType());
            return result;
        }
        return ValidationResult.makeSuccessResult();
    }

    protected <T> ConversionResult<T> validateCollectionConversion(Field unconvertedField, Annotation annotation, CollectionConverter<?, T> collectionConverter, String formValue, Field recipientField, Class<T> recipientClass) throws Exception {
        if (formValue != null || collectionConverter.getProcessNoValue()) {
            return collectionConverter.convert(formValue, recipientField.getType(), recipientClass);
        }
        return ConversionResult.makeSkippedCollectionResult(this.makeCollectionForRecipient(recipientField.getType()));
    }

    protected <T> ValidationResult validateCollectionPostConversion(Field unconvertedField, Annotation annotation, CollectionPostConversionValidator<?, T> collectionPostConversionValidator, Collection<T> convertedValue, Field recipientField, Class<?> recipientClass) throws Exception {
        return collectionPostConversionValidator.validate(convertedValue);
    }

    protected <T> ConversionResult<T> validateConversion(Field unconvertedField, Annotation annotation, Converter<?, T> converter, String fieldValue, Field recipientField, Class<T> recipientClass) throws Exception {
        if (fieldValue != null || converter.getProcessNoValue()) {
            return converter.convert(fieldValue, recipientClass);
        }
        return ConversionResult.makeSkippedResult();
    }

    protected ValidationResult validateNonConversion(Field unconvertedField, AnnotationEntry<?> annotationEntry, String fieldValue) throws Exception {
        if (fieldValue.length() > 0 || annotationEntry.getConfiguredPolicy().getNonConversionValidator().getProcessNoValue()) {
            return annotationEntry.getConfiguredPolicy().getNonConversionValidator().validate(fieldValue);
        }
        return ValidationResult.makeSuccessResult();
    }

    protected <T> ValidationResult validatePostConversion(Field unconvertedField, Annotation annotation, PostConversionValidator<?, T> postConversionValidator, T convertedValue, Field recipientField, Class<T> recipientClass) throws Exception {
        return postConversionValidator.validate(convertedValue);
    }

    protected void writeFieldError(ValidationAware validationAware, String fieldName, String message) {
        if (validationAware != null) {
            validationAware.addFieldError(fieldName, message);
        }
    }

    protected void writeGeneralError(ValidationAware validationAware, String message) {
        if (validationAware != null) {
            validationAware.addActionError(message);
        }
    }

    protected void writeInfoMessage(ValidationAware validationAware, String message) {
        if (validationAware != null) {
            validationAware.addActionMessage(message);
        }
    }

    protected void writeWarningMessage(ValidationAware validationAware, String message) {
        if (validationAware != null && validationAware instanceof ValidationAware2) {
            ((ValidationAware2)validationAware).addActionWarning(message);
        } else if (validationAware != null) {
            validationAware.addActionMessage(message);
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public static class AnnotationEntry<T> {
        private Annotation annotation;
        private InterceptorCommonLibrary.ConfiguredPolicy<T> configuredPolicy;

        public AnnotationEntry(Annotation annotation, InterceptorCommonLibrary.ConfiguredPolicy<T> configuredPolicy) {
            this.annotation = annotation;
            this.configuredPolicy = configuredPolicy;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public InterceptorCommonLibrary.ConfiguredPolicy<T> getConfiguredPolicy() {
            return this.configuredPolicy;
        }
    }

    public static class ConversionFieldResult<T> {
        private ConversionResult<T> conversionResult;
        private Field recipeintField;

        public ConversionFieldResult(Field recipeintField, ConversionResult<T> conversionResult) {
            this.recipeintField = recipeintField;
            this.conversionResult = conversionResult;
        }

        public ConversionResult<T> getConversionResult() {
            return this.conversionResult;
        }

        public Field getRecipeintField() {
            return this.recipeintField;
        }
    }
}

