/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import name.matthewgreet.strutscommons.action.AbstractViewActionSupport;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.ListCacheRecordComparator;
import name.matthewgreet.strutscommons.util.ListFinder;
import name.matthewgreet.strutscommons.view.FormattedListDisplay;

public abstract class AbstractViewListActionSupport<M extends Serializable, K extends Serializable, T extends Serializable, FT>
extends AbstractViewActionSupport {
    private static final long serialVersionUID = -4166079641325035739L;
    public static final String PARAMETER_NAME_INDEXSELECT = "select";
    public static final String PARAMETER_NAME_PAGE = "page";
    public static final String PARAMETER_NAME_RELOAD = "reload";
    public static final String PARAMETER_VALUE_RELOAD_TRUE = "true";
    public static final String PARAMETER_NAME_SORT_ASCENDING = "ascending";
    public static final String PARAMETER_NAME_SORT_OPTION = "sort";
    public static final String PARAMETER_NAME_MASTER_INDEXSELECT = "masterSelect";
    private final ViewListConfig config = this.getViewListConfig();
    private List<T> unformattedList;
    private FormattedListDisplay<FT> formattedList;
    private int formatRecordIndex;

    private int calcPageNo(int index) {
        if (this.config.getPageMode()) {
            return index / this.config.getPageSize() + 1;
        }
        return 1;
    }

    private int checkIndexInPage(int currentIndex, int pageNo) throws Exception {
        int pageSize = this.config.getPageSize();
        int workingIndex = currentIndex;
        if (currentIndex > -1 && this.config.getPageMode() && (currentIndex < this.getStartIndex(pageNo, pageSize) || currentIndex > this.getEndIndex(pageNo, pageSize))) {
            workingIndex = this.getStartIndex(pageNo, pageSize);
        }
        return workingIndex;
    }

    private void checkListOrPage(ListCache<M, ?, T> listCache) throws Exception {
        if (this.config.getPageMode()) {
            listCache.getPage();
        } else {
            listCache.getList();
        }
    }

    private int checkPageNo(int page, int listSize) throws Exception {
        int result;
        if (this.config.getPageMode()) {
            result = page;
            result = result < 1 ? 1 : result;
            int totalPages = this.getTotalPages(listSize);
            result = result > totalPages ? totalPages : result;
            result = result < 1 ? 1 : result;
        } else {
            result = 1;
        }
        return result;
    }

    private Integer checkPageParameter(HttpServletRequest request) {
        String select = request.getParameter(this.config.getParameterNamePage());
        if (select != null) {
            try {
                return Integer.parseInt(select);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Value of page parameter is not a number  select=" + select);
                return null;
            }
        }
        return null;
    }

    private void checkReload(HttpServletRequest request, ListCache<M, ?, T> listCache) {
        String reload = request.getParameter(this.config.getParameterNameReload());
        if (reload != null && reload.equals(PARAMETER_VALUE_RELOAD_TRUE) || reload == null && this.config.getReloadDefault()) {
            listCache.markReload();
        }
    }

    private int getEndIndex(int page, int pageSize) {
        return page * pageSize - 1;
    }

    private Integer getIndexSelect() {
        HttpServletRequest request = this.getServletRequest();
        String select = request.getParameter(this.config.getParameterNameIndexSelect());
        if (select != null) {
            try {
                return Integer.parseInt(select);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Value of select parameter is not a number  select=" + select);
            }
        }
        return null;
    }

    private Integer getMasterIndexSelect() {
        HttpServletRequest request = this.getServletRequest();
        String masterSelect = request.getParameter(this.config.getParameterNameMasterIndexSelect());
        if (masterSelect != null) {
            try {
                return Integer.parseInt(masterSelect);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Value of masterSelect parameter is not a number  masterSelect=" + masterSelect);
            }
        }
        return null;
    }

    private Boolean getSortAscendingParameter(HttpServletRequest request) {
        String value = this.getServletRequest().getParameter(this.config.getParameterNameSortAscending());
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private String getSortOptionParameter() {
        String result = this.getServletRequest().getParameter(this.config.getParameterNameSortOption());
        return result;
    }

    private int getStartIndex(int page, int pageSize) {
        return (page - 1) * pageSize;
    }

    private int getTotalPages(int listSize) {
        if (this.config.getPageMode()) {
            return (int)Math.ceil((float)listSize / (float)this.config.getPageSize());
        }
        return 1;
    }

    protected String checkRedirect() {
        return null;
    }

    protected void endRecordFormatting() throws Exception {
    }

    protected abstract FT formatRecord(M var1, T var2);

    protected Integer getAlternateIndex(ListCache<M, K, T> listCache) {
        return null;
    }

    protected ListFinder<M, T> getFindCommand(M selectedMaster) throws Exception {
        return null;
    }

    protected int getFormatRecordIndex() {
        return this.formatRecordIndex;
    }

    protected ListCacheRecordComparator<T> getItemSorter(String sortOption, Boolean sortAscending) {
        return null;
    }

    protected abstract ListCache<M, K, T> getListCache();

    protected abstract ListCache<?, ?, M> getMasterListCache();

    protected abstract ViewListConfig getViewListConfig();

    protected String getViewResponse(M selectedMaster, T selectedItem) throws Exception {
        return "success";
    }

    protected void startRecordFormatting() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        T selectedItem;
        int newPage;
        int listSize;
        M selectedMaster;
        int newIndex;
        String forward = this.checkRedirect();
        if (forward != null) {
            return forward;
        }
        HttpServletRequest request = this.getServletRequest();
        ListCache<?, ?, M> masterListCache = this.getMasterListCache();
        ListCache<Object, K, T> listCache = this.getListCache();
        if (masterListCache != null && masterListCache != listCache) {
            Integer masterIndexSelect = this.getMasterIndexSelect();
            if (masterIndexSelect != null) {
                newIndex = masterIndexSelect;
                if (newIndex >= masterListCache.getListSize()) {
                    newIndex = masterListCache.getListSize() - 1;
                } else if (newIndex < 0) {
                    newIndex = -1;
                }
                masterListCache.setSelectedIndex(newIndex);
            }
            selectedMaster = this.config.getRequireSelectedMasterDetail() ? (M)masterListCache.getSelected() : (M)masterListCache.getSelectedNoDetail();
        } else {
            selectedMaster = null;
        }
        ListCache<Object, K, T> listCache2 = listCache;
        synchronized (listCache2) {
            ListFinder<Object, T> newListFinder = this.getFindCommand(selectedMaster);
            if (newListFinder != null) {
                listCache.setListFinder(newListFinder);
                listCache.markReload();
            }
            this.checkReload(request, listCache);
            String sortOption = this.getSortOptionParameter();
            if (sortOption != null) {
                Boolean sortAscending = this.getSortAscendingParameter(request);
                ListCacheRecordComparator<T> itemSorter = this.getItemSorter(sortOption, sortAscending);
                listCache.setItemSorter(itemSorter);
                listCache.markReSort();
            }
            listSize = listCache.getListSize();
            Integer pageSelect = this.checkPageParameter(request);
            Integer indexSelect = this.getIndexSelect();
            if (indexSelect == null) {
                indexSelect = this.getAlternateIndex(listCache);
            }
            if (this.config.getPageMode()) {
                listCache.setPageSize(this.config.getPageSize());
            }
            if (indexSelect != null) {
                newIndex = indexSelect;
                if (newIndex >= listSize) {
                    newIndex = listSize - 1;
                } else if (newIndex < 0) {
                    newIndex = -1;
                }
                newPage = this.calcPageNo(newIndex);
            } else if (pageSelect != null) {
                newPage = pageSelect;
                newPage = this.checkPageNo(newPage, listSize);
                listCache.setPageNo(newPage);
                this.checkListOrPage(listCache);
                newIndex = listCache.getSelectedIndex();
                newIndex = this.checkIndexInPage(newIndex, newPage);
            } else {
                newIndex = listCache.getSelectedIndex();
                newPage = this.calcPageNo(newIndex);
            }
            this.checkListOrPage(listCache);
            listCache.setSelectedIndex(newIndex);
            selectedItem = this.config.getRequireSelectedItemDetail() ? listCache.getSelected() : listCache.getSelectedNoDetail();
        }
        int startIndex = this.getStartIndex(newPage, this.config.getPageSize());
        this.formattedList = new FormattedListDisplay();
        this.formattedList.setPageMode(this.config.getPageMode());
        this.formattedList.setTotalItems(listCache.getListSize());
        if (this.config.getIgnoreList()) {
            this.unformattedList = new ArrayList<T>();
            this.formattedList.setSelectedIndex(-1);
            this.formattedList.setPage(0);
            this.formattedList.setPageSize(0);
            this.formattedList.setTotalPages(this.getTotalPages(listSize));
        } else if (this.config.getPageMode()) {
            this.unformattedList = listCache.getPage();
            this.formattedList.setSelectedIndex(newPage > 0 ? listCache.getSelectedIndex() - startIndex : -1);
            this.formattedList.setPage(newPage);
            this.formattedList.setPageSize(this.config.getPageSize());
            this.formattedList.setTotalPages(this.getTotalPages(listSize));
        } else {
            this.unformattedList = listCache.getList();
            this.formattedList.setSelectedIndex(listCache.getSelectedIndex());
            this.formattedList.setPage(1);
            this.formattedList.setPageSize(listSize);
            this.formattedList.setTotalPages(1);
        }
        this.startRecordFormatting();
        ArrayList<FT> formattedSublist = new ArrayList<FT>();
        this.formatRecordIndex = startIndex;
        for (Serializable record : this.unformattedList) {
            formattedSublist.add(this.formatRecord(selectedMaster, record));
            ++this.formatRecordIndex;
        }
        this.endRecordFormatting();
        this.formattedList.setList(formattedSublist);
        forward = this.getViewResponse(selectedMaster, selectedItem);
        return forward;
    }

    public ViewListConfig getConfig() {
        return this.config;
    }

    public FormattedListDisplay<FT> getFormattedList() {
        return this.formattedList;
    }

    public FT getFormattedSelectedItem() {
        return this.formattedList.getSelectedItem();
    }

    public boolean getExistingSelection() {
        return this.formattedList.getSelectedIndex() > -1;
    }

    public List<T> getUnformattedList() {
        return this.unformattedList;
    }

    public T getUnformattedSelectedItem() {
        if (this.formattedList.getSelectedIndex() > -1) {
            return (T)((Serializable)this.unformattedList.get(this.formattedList.getSelectedIndex()));
        }
        return null;
    }

    public static class ViewListConfig {
        private boolean ignoreList = false;
        private boolean pageMode = false;
        private int pageSize = 5;
        private boolean reloadDefault = false;
        private boolean requireSelectedMasterDetail = true;
        private boolean requireSelectedItemDetail = true;
        private String errorForwardName = "error";
        private String parameterNameIndexSelect = "select";
        private String parameterNameMasterIndexSelect = "masterSelect";
        private String parameterNamePage = "page";
        private String parameterNameReload = "reload";
        private String parameterNameSortAscending = "ascending";
        private String parameterNameSortOption = "sort";

        public static ViewListConfig makeNoListConfig() {
            ViewListConfig result = new ViewListConfig();
            result.setIgnoreList(true);
            result.setPageMode(false);
            result.setRequireSelectedMasterDetail(false);
            result.setRequireSelectedItemDetail(false);
            return result;
        }

        public static ViewListConfig makeNonPagedListConfig() {
            ViewListConfig result = new ViewListConfig();
            result.setPageMode(false);
            result.setRequireSelectedMasterDetail(true);
            result.setRequireSelectedItemDetail(false);
            return result;
        }

        public static ViewListConfig makePagedListConfig(int pageSize) {
            ViewListConfig result = new ViewListConfig();
            result.setPageMode(true);
            result.setPageSize(pageSize);
            result.setRequireSelectedMasterDetail(true);
            result.setRequireSelectedItemDetail(false);
            return result;
        }

        public static ViewListConfig makeSingleRecordConfig() {
            ViewListConfig result = new ViewListConfig();
            result.setPageMode(true);
            result.setPageSize(1);
            result.setRequireSelectedMasterDetail(true);
            result.setRequireSelectedItemDetail(true);
            return result;
        }

        public boolean getIgnoreList() {
            return this.ignoreList;
        }

        public void setIgnoreList(boolean ignoreList) {
            this.ignoreList = ignoreList;
        }

        public boolean getPageMode() {
            return this.pageMode;
        }

        public void setPageMode(boolean value) {
            this.pageMode = value;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int value) {
            this.pageSize = value > 0 ? value : 1;
        }

        public boolean getReloadDefault() {
            return this.reloadDefault;
        }

        public void setReloadDefault(boolean value) {
            this.reloadDefault = value;
        }

        public boolean getRequireSelectedMasterDetail() {
            return this.requireSelectedMasterDetail;
        }

        public void setRequireSelectedMasterDetail(boolean requireSelectedMasterDetail) {
            this.requireSelectedMasterDetail = requireSelectedMasterDetail;
        }

        public boolean getRequireSelectedItemDetail() {
            return this.requireSelectedItemDetail;
        }

        public void setRequireSelectedItemDetail(boolean requireSelectedItemDetail) {
            this.requireSelectedItemDetail = requireSelectedItemDetail;
        }

        public String getErrorForwardName() {
            return this.errorForwardName;
        }

        public void setErrorForwardName(String value) {
            this.errorForwardName = value;
        }

        public String getParameterNameIndexSelect() {
            return this.parameterNameIndexSelect;
        }

        public void setParameterNameIndexSelect(String value) {
            this.parameterNameIndexSelect = value;
        }

        public String getParameterNameMasterIndexSelect() {
            return this.parameterNameMasterIndexSelect;
        }

        public void setParameterNameMasterIndexSelect(String value) {
            this.parameterNameMasterIndexSelect = value;
        }

        public String getParameterNamePage() {
            return this.parameterNamePage;
        }

        public void setParameterNamePage(String value) {
            this.parameterNamePage = value;
        }

        public String getParameterNameReload() {
            return this.parameterNameReload;
        }

        public void setParameterNameReload(String value) {
            this.parameterNameReload = value;
        }

        public String getParameterNameSortAscending() {
            return this.parameterNameSortAscending;
        }

        public void setParameterNameSortAscending(String parameterNameSortAscending) {
            this.parameterNameSortAscending = parameterNameSortAscending;
        }

        public String getParameterNameSortOption() {
            return this.parameterNameSortOption;
        }

        public void setParameterNameSortOption(String parameterNameSortOption) {
            this.parameterNameSortOption = parameterNameSortOption;
        }
    }
}

