/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.util.ListCache;

public abstract class AbstractSaveListActionSupport<M extends Serializable, K extends Serializable, T extends Serializable, F extends AbstractForm>
extends AbstractFormDrivenActionSupport<F> {
    private static final long serialVersionUID = 8213325828567959710L;
    public static final String PARAMETER_NAME_INDEXSELECT = "select";
    private final SaveListConfig config = this.getSaveListConfig();

    private Integer checkIndexSelect(HttpServletRequest request) {
        String select = request.getParameter(this.config.getParameterNameIndexSelect());
        if (select != null) {
            try {
                return Integer.parseInt(select);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Value of select parameter is not a number  select=" + select);
            }
        }
        return null;
    }

    public String execute() throws Exception {
        String forward;
        HttpServletRequest request = this.getServletRequest();
        ListCache<?, ?, M> masterListCache = this.getMasterListCache();
        ListCache<M, K, Serializable> listCache = this.getListCache();
        SaveResponse<T> saveResponse = null;
        int listSize = listCache.getListSize();
        Integer indexSelect = this.checkIndexSelect(request);
        if (indexSelect == null) {
            indexSelect = this.getAlternateIndex(listCache);
        }
        if (this.hasErrors()) {
            return "input";
        }
        if (indexSelect != null) {
            int newIndex = indexSelect;
            if (newIndex >= listSize) {
                newIndex = listSize - 1;
            } else if (newIndex < 0) {
                newIndex = -1;
            }
            listCache.setSelectedIndex(newIndex);
        }
        M selectedMaster = masterListCache != null && masterListCache != listCache ? (M)masterListCache.getSelected() : null;
        saveResponse = this.doSave(selectedMaster, listCache.getSelected());
        SaveResponse.ListAction listAction = saveResponse.getListAction();
        Serializable updatedItem = (Serializable)saveResponse.getUpdatedItem();
        switch (listAction.ordinal()) {
            case 0: {
                listCache.addItem(updatedItem);
                if (listCache.getItemFinder() != null) {
                    listCache.markSelectedReload();
                    break;
                }
                listCache.markReload();
                break;
            }
            case 1: {
                listCache.addItem(updatedItem);
                break;
            }
            case 2: {
                listCache.setSelectedIndex(-1);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                if (listCache.getItemFinder() != null) {
                    listCache.markSelectedReload();
                    break;
                }
                listCache.markReload();
                break;
            }
            case 6: {
                listCache.markReload();
                break;
            }
            case 7: {
                if (masterListCache != null) {
                    masterListCache.markSelectedReload();
                    break;
                }
                listCache.markSelectedReload();
                break;
            }
            case 4: {
                if (masterListCache != null) {
                    masterListCache.markReload();
                    break;
                }
                listCache.markReload();
                break;
            }
            case 8: {
                listCache.removeSelected();
            }
        }
        for (String message : saveResponse.getMessages()) {
            this.addActionMessage(message);
        }
        for (String errorMessage : saveResponse.getErrors()) {
            this.addActionError(errorMessage);
        }
        if (saveResponse.getSucceeded()) {
            if (saveResponse.getUpdateItem() && listAction == SaveResponse.ListAction.NONE) {
                listCache.setSelected(updatedItem);
            }
            forward = saveResponse.getSuccessResultName();
        } else {
            forward = saveResponse.getFailureResultName();
        }
        return forward;
    }

    protected abstract SaveResponse<T> doSave(M var1, T var2) throws Exception;

    protected Integer getAlternateIndex(ListCache<M, K, T> listCache) {
        return null;
    }

    protected abstract ListCache<M, K, T> getListCache();

    protected abstract ListCache<?, ?, M> getMasterListCache();

    protected abstract SaveListConfig getSaveListConfig();

    public static class SaveListConfig {
        private String errorForwardName;
        private String parameterNameIndexSelect;

        public SaveListConfig() {
            this.errorForwardName = null;
            this.parameterNameIndexSelect = AbstractSaveListActionSupport.PARAMETER_NAME_INDEXSELECT;
        }

        public SaveListConfig(String errorForwardName) {
            this.errorForwardName = errorForwardName;
            this.parameterNameIndexSelect = AbstractSaveListActionSupport.PARAMETER_NAME_INDEXSELECT;
        }

        public String getErrorForwardName() {
            return this.errorForwardName;
        }

        public void setErrorForwardName(String value) {
            this.errorForwardName = value;
        }

        public String getParameterNameIndexSelect() {
            return this.parameterNameIndexSelect;
        }

        public void setParameterNameIndexSelect(String value) {
            this.parameterNameIndexSelect = value;
        }
    }

    public static class SaveResponse<T> {
        private boolean succeeded = false;
        private String failureResultName = "input";
        private String successResultName = "success";
        private boolean updateItem = false;
        private T updatedItem = null;
        private ListAction listAction = ListAction.NONE;
        private Collection<String> errors = new ArrayList<String>();
        private Collection<String> messages = new ArrayList<String>();

        public static <T> SaveResponse<T> makeCreatedItemSuccessResponse(T createdItem, String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.ADD_ITEM);
            result.setSucceeded(true);
            result.setUpdatedItem(createdItem);
            result.setUpdateItem(true);
            return result;
        }

        public static <T> SaveResponse<T> makeCreatedAndReloadItemSuccessResponse(T createdItem, String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.ADD_AND_RELOAD_ITEM);
            result.setSucceeded(true);
            result.setUpdatedItem(createdItem);
            result.setUpdateItem(true);
            return result;
        }

        public static <T> SaveResponse<T> makeDeselectResponse() {
            SaveResponse<T> result = new SaveResponse<T>();
            result.setListAction(ListAction.DESELECT);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeFailureResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addErrorMessage(message);
            result.setListAction(ListAction.NONE);
            result.setSucceeded(false);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeFailureResponseExistingMessages() {
            SaveResponse<T> result = new SaveResponse<T>();
            result.setListAction(ListAction.NONE);
            result.setSucceeded(false);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeFailureAndReloadItemResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addErrorMessage(message);
            result.setListAction(ListAction.RELOAD_ITEM);
            result.setSucceeded(false);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeFailureAndReloadListResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addErrorMessage(message);
            result.setListAction(ListAction.RELOAD_LIST);
            result.setSucceeded(false);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeFailureAndReloadMasterResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addErrorMessage(message);
            result.setListAction(ListAction.RELOAD_MASTER);
            result.setSucceeded(false);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeInvisibleSuccessResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.NONE);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeRemovedItemSuccessResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.REMOVE_ITEM);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeSuccessAndReloadItemResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.RELOAD_ITEM);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeSuccessAndReloadListResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.RELOAD_LIST);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeSuccessAndReloadMasterResponse(String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.RELOAD_MASTER);
            result.setSucceeded(true);
            result.setUpdateItem(false);
            return result;
        }

        public static <T> SaveResponse<T> makeUpdatedItemSuccessResponse(T updatedItem, String message) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.addInfoMessage(message);
            result.setListAction(ListAction.NONE);
            result.setSucceeded(true);
            result.setUpdatedItem(updatedItem);
            result.setUpdateItem(true);
            return result;
        }

        public static <T> SaveResponse<T> makeUpdatedItemSuccessSilentResponse(T updatedItem) {
            SaveResponse<T> result = new SaveResponse<T>();
            result.setListAction(ListAction.NONE);
            result.setSucceeded(true);
            result.setUpdatedItem(updatedItem);
            result.setUpdateItem(true);
            return result;
        }

        public boolean getSucceeded() {
            return this.succeeded;
        }

        public void setSucceeded(boolean value) {
            this.succeeded = value;
        }

        public String getFailureResultName() {
            return this.failureResultName;
        }

        public void setFailureResultName(String value) {
            this.failureResultName = value;
        }

        public String getSuccessResultName() {
            return this.successResultName;
        }

        public void setSuccessResultName(String value) {
            this.successResultName = value;
        }

        public boolean getUpdateItem() {
            return this.updateItem;
        }

        public void setUpdateItem(boolean value) {
            this.updateItem = value;
        }

        public T getUpdatedItem() {
            return this.updatedItem;
        }

        public void setUpdatedItem(T value) {
            this.updatedItem = value;
        }

        public ListAction getListAction() {
            return this.listAction;
        }

        public void setListAction(ListAction value) {
            this.listAction = value;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }

        public Collection<String> getMessages() {
            return this.messages;
        }

        public void addErrorMessage(String text) {
            this.errors.add(text);
        }

        public void addInfoMessage(String text) {
            this.messages.add(text);
        }

        public static enum ListAction {
            ADD_AND_RELOAD_ITEM,
            ADD_ITEM,
            DESELECT,
            NONE,
            RELOAD_ENTIRE,
            RELOAD_ITEM,
            RELOAD_LIST,
            RELOAD_MASTER,
            REMOVE_ITEM;

        }
    }
}

