/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.ListSizeFinder;
import name.matthewgreet.strutscommons.util.PageByIndexRangeFinder;

public abstract class AbstractFindIndexListActionSupport<M extends Serializable, T extends Serializable, F extends AbstractForm>
extends AbstractFormDrivenActionSupport<F> {
    private static final long serialVersionUID = -5096119843738470346L;

    protected abstract FindIndexListResponse<M, T> getFindCommand(M var1) throws Exception;

    protected abstract FindIndexListConfig getFindIndexListConfig();

    protected abstract ListCache<M, ?, T> getListCache();

    protected abstract ListCache<?, ?, M> getMasterListCache();

    protected String translateFinderException(ListSizeFinder<M> sizeFinderCommand, Exception e) {
        return null;
    }

    public String execute() throws Exception {
        FindIndexListConfig config = this.getFindIndexListConfig();
        FindIndexListResponse<Object, T> findResponse = null;
        ListSizeFinder<Object> sizeFinderCommand = null;
        String errorMessage = null;
        ListCache<?, ?, M> masterListCache = this.getMasterListCache();
        ListCache<Object, ?, T> listCache = this.getListCache();
        try {
            Object selectedMaster = masterListCache != null && masterListCache != listCache ? (Object)masterListCache.getSelected() : null;
            findResponse = this.getFindCommand(selectedMaster);
            if (!findResponse.getRejected()) {
                sizeFinderCommand = findResponse.getSizeFinderCommand();
                int size = findResponse.getListSize() != null ? findResponse.getListSize().intValue() : sizeFinderCommand.getSize(selectedMaster);
                if (!config.getRejectNoMatch() || size > 0) {
                    listCache.setListSizeAndFinder(size, sizeFinderCommand, findResponse.getPageFinderCommand());
                } else {
                    this.addActionError(config.getRejectMessage());
                }
            }
        }
        catch (Exception e) {
            if (sizeFinderCommand != null) {
                errorMessage = this.translateFinderException(sizeFinderCommand, e);
            }
            if (errorMessage == null || errorMessage.length() == 0) {
                errorMessage = "No results found";
            }
            this.addActionError(errorMessage);
        }
        if (findResponse != null) {
            for (String message : findResponse.getMessages()) {
                this.addActionMessage(message);
            }
            for (String errorMessage2 : findResponse.getErrors()) {
                this.addActionError(errorMessage2);
            }
            if (!findResponse.getRejected()) {
                return findResponse.getSuccessResultName();
            }
            return findResponse.getFailureResultName();
        }
        return "error";
    }

    public static class FindIndexListConfig {
        private boolean rejectNoMatch = false;
        private String rejectMessage = "No results found";
        private String errorForwardName = "error";

        public boolean getRejectNoMatch() {
            return this.rejectNoMatch;
        }

        public void setRejectNoMatch(boolean value) {
            this.rejectNoMatch = value;
        }

        public String getRejectMessage() {
            return this.rejectMessage;
        }

        public void setRejectMessage(String value) {
            this.rejectMessage = value;
        }

        public String getErrorForwardName() {
            return this.errorForwardName;
        }

        public void setErrorForwardName(String value) {
            this.errorForwardName = value;
        }
    }

    public static class FindIndexListResponse<M extends Serializable, T extends Serializable> {
        private boolean rejected = true;
        private String failureResultName = "input";
        private String successResultName = "success";
        private ListSizeFinder<M> sizeFinderCommand;
        private PageByIndexRangeFinder<M, T> pageFinderCommand;
        private Integer listSize = null;
        private Collection<String> errors = new ArrayList<String>();
        private Collection<String> messages = new ArrayList<String>();

        public static <M extends Serializable, T extends Serializable> FindIndexListResponse<M, T> makeFailureResponse(String message) {
            FindIndexListResponse<M, T> result = new FindIndexListResponse<M, T>();
            result.addErrorMessage(message);
            return result;
        }

        public static <M extends Serializable, T extends Serializable> FindIndexListResponse<M, T> makeSuccessResponse(ListSizeFinder<M> sizeFinderCommand, PageByIndexRangeFinder<M, T> pageFinderCommand) {
            FindIndexListResponse<M, T> result = new FindIndexListResponse<M, T>(sizeFinderCommand, pageFinderCommand);
            return result;
        }

        public static <M extends Serializable, T extends Serializable> FindIndexListResponse<M, T> makeSuccessWithListSizeResponse(ListSizeFinder<M> sizeFinderCommand, PageByIndexRangeFinder<M, T> pageFinderCommand, int listSize) {
            FindIndexListResponse<M, T> result = new FindIndexListResponse<M, T>(sizeFinderCommand, pageFinderCommand);
            result.setListSize(listSize);
            return result;
        }

        public FindIndexListResponse() {
            this.rejected = true;
        }

        public FindIndexListResponse(ListSizeFinder<M> sizeFinderCommand, PageByIndexRangeFinder<M, T> pageFinderCommand) {
            this.rejected = false;
            this.sizeFinderCommand = sizeFinderCommand;
            this.pageFinderCommand = pageFinderCommand;
        }

        public boolean getRejected() {
            return this.rejected;
        }

        public ListSizeFinder<M> getSizeFinderCommand() {
            return this.sizeFinderCommand;
        }

        public PageByIndexRangeFinder<M, T> getPageFinderCommand() {
            return this.pageFinderCommand;
        }

        public String getFailureResultName() {
            return this.failureResultName;
        }

        public void setFailureResultName(String value) {
            this.failureResultName = value;
        }

        public String getSuccessResultName() {
            return this.successResultName;
        }

        public void setSuccessResultName(String value) {
            this.successResultName = value;
        }

        public Integer getListSize() {
            return this.listSize;
        }

        public void setListSize(Integer listSize) {
            this.listSize = listSize;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }

        public Collection<String> getMessages() {
            return this.messages;
        }

        public void addErrorMessage(String text) {
            this.errors.add(text);
        }

        public void addInfoMessage(String text) {
            this.messages.add(text);
        }
    }
}

