/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.util.IdListFinder;
import name.matthewgreet.strutscommons.util.ListCache;

public abstract class AbstractFindIdListActionSupport<M extends Serializable, K extends Serializable, F extends AbstractForm>
extends AbstractFormDrivenActionSupport<F> {
    private static final long serialVersionUID = -5096119843738470346L;

    protected abstract FindIdListResponse<M, K> getFindCommand(M var1) throws Exception;

    protected abstract FindIdListConfig getFindIdListConfig();

    protected abstract ListCache<M, K, ?> getListCache(HttpSession var1);

    protected abstract ListCache<?, ?, M> getMasterListCache(HttpSession var1);

    protected String translateFinderException(IdListFinder<M, K> finderCommand, Exception e) {
        return null;
    }

    public String execute() throws Exception {
        FindIdListConfig config = this.getFindIdListConfig();
        FindIdListResponse<Object, K> findResponse = null;
        IdListFinder<Object, K> finderCommand = null;
        String errorMessage = null;
        HttpServletRequest request = this.getServletRequest();
        HttpSession session = request.getSession();
        ListCache<?, ?, M> masterListCache = this.getMasterListCache(session);
        ListCache<Object, K, ?> listCache = this.getListCache(session);
        try {
            session = request.getSession();
            Object selectedMaster = masterListCache != null && masterListCache != listCache ? (Object)masterListCache.getSelected() : null;
            findResponse = this.getFindCommand(selectedMaster);
            if (!findResponse.getRejected()) {
                finderCommand = findResponse.getFinderCommand();
                List<K> ids = findResponse.getIds() != null ? findResponse.getIds() : finderCommand.getIds(selectedMaster);
                if (ids == null) {
                    ids = new ArrayList<K>();
                }
                if (!config.getRejectNoMatch() || ids.size() > 0) {
                    listCache.setIdListAndFinder(ids, finderCommand);
                } else {
                    this.addActionError(config.getRejectMessage());
                }
            }
        }
        catch (Exception e) {
            if (finderCommand != null) {
                errorMessage = this.translateFinderException(finderCommand, e);
            }
            if (errorMessage == null || errorMessage.length() == 0) {
                errorMessage = "No results found";
            }
            this.addActionError(errorMessage);
        }
        if (findResponse != null) {
            for (String message : findResponse.getMessages()) {
                this.addActionMessage(message);
            }
            for (String errorMessage2 : findResponse.getErrors()) {
                this.addActionError(errorMessage2);
            }
            if (!findResponse.getRejected()) {
                return findResponse.getSuccessResultName();
            }
            return findResponse.getFailureResultName();
        }
        return "error";
    }

    public static class FindIdListConfig {
        private boolean rejectNoMatch = false;
        private String rejectMessage = "No results found";
        private String errorForwardName = "error";

        public boolean getRejectNoMatch() {
            return this.rejectNoMatch;
        }

        public void setRejectNoMatch(boolean value) {
            this.rejectNoMatch = value;
        }

        public String getRejectMessage() {
            return this.rejectMessage;
        }

        public void setRejectMessage(String value) {
            this.rejectMessage = value;
        }

        public String getErrorForwardName() {
            return this.errorForwardName;
        }

        public void setErrorForwardName(String value) {
            this.errorForwardName = value;
        }
    }

    public static class FindIdListResponse<M extends Serializable, K extends Serializable> {
        private boolean rejected = true;
        private String failureResultName = "input";
        private String successResultName = "success";
        private IdListFinder<M, K> finderCommand;
        private List<K> ids = null;
        private Collection<String> errors = new ArrayList<String>();
        private Collection<String> messages = new ArrayList<String>();

        public static <M extends Serializable, K extends Serializable> FindIdListResponse<M, K> makeFailureResponse(String message) {
            FindIdListResponse<M, K> result = new FindIdListResponse<M, K>();
            result.addErrorMessage(message);
            return result;
        }

        public static <M extends Serializable, K extends Serializable> FindIdListResponse<M, K> makeSuccessResponse(IdListFinder<M, K> finderCommand) {
            FindIdListResponse<M, K> result = new FindIdListResponse<M, K>(finderCommand);
            return result;
        }

        public static <M extends Serializable, K extends Serializable> FindIdListResponse<M, K> makeSuccessWithIdsResponse(IdListFinder<M, K> finderCommand, List<K> ids) {
            FindIdListResponse<M, K> result = new FindIdListResponse<M, K>(finderCommand);
            result.setIds(ids);
            return result;
        }

        public FindIdListResponse() {
            this.rejected = true;
        }

        public FindIdListResponse(IdListFinder<M, K> finderCommand) {
            this.rejected = false;
            this.finderCommand = finderCommand;
        }

        public boolean getRejected() {
            return this.rejected;
        }

        public IdListFinder<M, K> getFinderCommand() {
            return this.finderCommand;
        }

        public String getFailureResultName() {
            return this.failureResultName;
        }

        public void setFailureResultName(String value) {
            this.failureResultName = value;
        }

        public String getSuccessResultName() {
            return this.successResultName;
        }

        public void setSuccessResultName(String value) {
            this.successResultName = value;
        }

        public List<K> getIds() {
            return this.ids;
        }

        public void setIds(List<K> ids) {
            this.ids = ids;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }

        public Collection<String> getMessages() {
            return this.messages;
        }

        public void addErrorMessage(String text) {
            this.errors.add(text);
        }

        public void addInfoMessage(String text) {
            this.messages.add(text);
        }
    }
}

