package name.matthewgreet.strutscommons.view;


/**
 * <P>Aids creation of OPTION tags in JSPs for SELECT elements by formatting items for display.  It may optionally 
 * contain item data.</P>
 */
public class SelectBoxItemDisplay<T> {
    private String value;
    private String text;
    private T data;
    private boolean selected;
    
    // Calculated variables
    private String checkedAttribute;
    private String selectedAttribute;
    
    public SelectBoxItemDisplay() {
        value = "";
        text = "";
        data = null;
        selected = false;
    }
    
    public SelectBoxItemDisplay(String value, String text) {
        setModel(value, text);
    }
    
    public SelectBoxItemDisplay(String value, String text, T data) {
        setModel(value, text, data);
    }
    
    
    public void setModel(String value, String text) {
        this.value 		= value;
        this.text 		= text;
        this.data 		= null;
    }

    public void setModel(String value, String text, T data) {
        this.value 		= value;
        this.text 		= text;
        this.data 		= data;
    }

    /**
     * Returns value to be used in VALUE attribute. 
     */
    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
    
    /**
     * Returns text displayed in web page. 
     */
    public String getText() {
        return text;
    }
    public void setText(String value) {
        this.text = value;
    }
    
    /**
     * Returns raw model item that is being formatted for display. 
     */
    public T getData() {
        return data;
    }
    public void setData(T value) {
        this.data = value;
    }
    

    public boolean getSelected() {
        return selected;
    }
    
    public void setSelected(boolean value) {
        selected = value;
        checkedAttribute = (selected?"CHECKED=\"TRUE\"":"");
        selectedAttribute = (selected?"SELECTED=\"TRUE\"":"");
    }

    /**
     * Convenience method for checkboxes. 
     */
    public String getCheckedAttribute() {
        return checkedAttribute;
    }
    
    /**
     * Convenience method for selection list items. 
     */
    public String getSelectedAttribute() {
        return selectedAttribute;
    }
    
}
