package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

@SuppressWarnings("rawtypes")
public class EnumConverter extends AbstractDefaultConverterSupport<EnumConversion,Enum> {
    private static final Logger LOG = LogManager.getLogger(EnumConverter.class);
    
    @EnumConversion
    private static boolean annotationPlaceholder;

	@Override
	protected EnumConversion makeDefaultAnnotation() {
		try {
			return EnumConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(EnumConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Enum unformattedValue) throws Exception {
        return unformattedValue.name();
    }

    @Override
    public Class<Enum> getRecipientClass() {
        return Enum.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @SuppressWarnings("unchecked")
    @Override
    public ConversionResult<Enum> convert(String formValue, Class<? extends Enum> recipientClass) throws Exception {
        Enum parsedValue;
        
        try {
            parsedValue = Enum.valueOf(recipientClass, formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (IllegalArgumentException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
