package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;
import java.util.Collection;

import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;

/**
 * Preferred template class for implementations of converters to collection-based data types that can be default 
 * collection converters. 
 */
public abstract class AbstractDefaultCollectionConverterSupport<A extends Annotation,T> extends AbstractCollectionConverterSupport<A,T>
        implements DefaultPolicy {

    protected Collection<T> makeCollectionForRecipient(Class<?> recipientFieldClass) {
        return InterceptorCommonLibrary.makeCollectionForRecipient(recipientFieldClass);
    }
    
	protected abstract A makeDefaultAnnotation();
	
    public A getAnnotation() {
    	A result;
    	
    	result = super.getAnnotation();
    	if (result == null) {
    		result = makeDefaultAnnotation();
    		super.setAnnotation(result);
    	}
        return result;
    }
}
