package name.matthewgreet.strutscommons.policy;

import java.util.Collection;

import name.matthewgreet.strutscommons.annotation.CustomCollectionPostConversionValidation;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;


/**
 * Template class for client supplied validators that validates a converted form field value that are collections.  
 * Subclasses must implement {@link #getRecipientClass} and {@link #validate #validate}.   
 */
public abstract class AbstractCustomCollectionPostConversionValidatorSupport<T> extends AbstractCollectionPostConversionValidatorSupport<CustomCollectionPostConversionValidation,T> {
    
    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }
    
	@Override
	public boolean getProcessNoValue() {
		return getAnnotation().processNoValue();
	}

    @Override
    public abstract ValidationResult validate(Collection<T> formValue);

}
