package name.matthewgreet.strutscommons.interceptor;



import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.StrutsStatics;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;

import name.matthewgreet.strutscommons.action.BrowserTabAware;
import name.matthewgreet.strutscommons.util.ServletLibrary;


/**
 * If the action implements BrowserTabAware, sets tab id from cookies.  The requesting web page must be set up for this 
 * to be correct.  See {@link ServletLibrary#getBrowserTabId ServletLibrary#getBrowserTabId}.
 *   
 * <P><U>Interceptor parameters</U></P>
 * <DL>
 * <DT>disabled</DT><DD>If true, all processing is disabled.  Defaults to false.</DD>
 * </DL>
 * 
 * <P><U>Extending the interceptor</U></P>
 * <P>This can't be usefully extended.</P>
 * 
 * <P><U>Example code</U></P>
 * <PRE>
 * &#064;InterceptorRefs({
 *   &#064;InterceptorRef(value="browserTab"),
 *   &#064;InterceptorRef(value="defaultStack")
 *})
 * </PRE>
 */
@SuppressWarnings("deprecation")
public class BrowserTabInterceptor extends AbstractInterceptor {
    private static final long serialVersionUID = -1555224920319813415L;

    private boolean disabled;
    
    /**
     * Sets tab id of Action read from user agent's cookies.  
     */
    private void setBrowserTabId(BrowserTabAware browserTabAware, ActionInvocation invocation) {
        HttpServletRequest request;
        Cookie[] cookies;
        String cookieValue;
        
        try {
            request = (HttpServletRequest)invocation.getInvocationContext().get(StrutsStatics.HTTP_REQUEST);
            cookies = request.getCookies();
        }
        catch (Exception e) {
            cookies = null;
        }
        cookieValue = ServletLibrary.getBrowserTabId(cookies);
        cookieValue = (cookieValue != null)?cookieValue:"";
        browserTabAware.setTabId(cookieValue);
    }

    public boolean getDisabled() {
		return disabled;
	}
	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
    	String result;
    	
        if (!disabled && invocation.getAction() instanceof BrowserTabAware) {
            setBrowserTabId((BrowserTabAware)invocation.getAction(), invocation);
        }
        result = invocation.invoke();
        return result;
    }

}
