package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

/**
 * <P>Defines a form field (whether on a Struts Action or model of ModelDriven Struts Action) should be parsed from 
 * comma separated values to some collection of String.  Different separators can be set instead of 
 * comma.  No error message can happen.  Also, defines a view helper field receives a formatted 
 * string collection value.</P>
 *
 * <P>There are two modes of behaviour for conversion, depending on the type of form field.</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Validation Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Form field type</TH>
 *     <TH>Mode</TH>
 *     <TH>Description</TH>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String</TD>
 *     <TD>Pair conversion</TD>
 *     <TD>Converts string field value to String collection type field named by parsedFieldName</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>String collection type</TD>
 *     <TD>Auto conversion</TD>
 *     <TD>Converts directly from request parameter</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Other Parameters</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>parsedFieldName</TD>
 *     <TD>If not empty string, name of field to contain parsed value.  Defaults to 'parsed' plus capitalised field 
 *         name, such as 'parsedLimit'.  Only applies for pair conversion.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>separator</TD>
 *     <TD>Separator between text.  Defaults to ','.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>trim</TD>
 *     <TD>Whether to trim whitespace from each entry using the trim function.  Defaults to true.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>When applied to a view helper field, {@link StrutsMiscellaneousLibrary#updateDisplay StrutsMiscellaneousLibrary#updateDisplay} 
 *    formats from a source record field with the same name but only certain combinations are recognised.</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Formatting Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Display field type</TH>
 *     <TH>Record field type</TH>
 *     <TH>Notes</TH>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String</TD>
 *     <TD>String collection</TD>
 *     <TD></TD>
 *   </TR>
 * </TABLE>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface StringCSVConversion {
    public String parsedFieldName() default "";
    public String separator() default ",";
    public boolean trim() default true;
}
