package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <P>Annotates an otherwise non-annotated form field (whether on a Struts Action or model of ModelDriven Struts Action) 
 *    so it's not ignored by <CODE>AnnotationValidationInterceptor2</CODE> instances configured to ignore non-annotated 
 *    fields.  Usually, this only applies to member fields of viewer Actions that receive URL parameters.</P>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FormField {
    // Empty
}
