/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.view;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import name.matthewgreet.strutscommons.view.SelectBoxItemDisplay2;

public abstract class EnumSingleSelectBoxDisplay2<E extends Enum<E>> {
    private List<SelectBoxItemDisplay2<E, E>> formattedModel = new ArrayList<SelectBoxItemDisplay2<E, E>>();
    private int selectedIndex = -1;

    public EnumSingleSelectBoxDisplay2() {
        for (Enum item : this.getEnumValues()) {
            if (!this.isAllowed(item)) continue;
            String value = this.getValue(item);
            String text = this.getText(item);
            SelectBoxItemDisplay2<Enum, Enum> formattedItem = this.makeSelectBoxItemDisplay(value, text, item);
            this.formattedModel.add(formattedItem);
        }
        Collections.sort(this.formattedModel, this.getSortComparator());
        this.addItems(this.formattedModel);
        if (this.hasBlankValue()) {
            this.formattedModel.add(0, this.makeSelectBoxItemDisplay("", this.getBlankText(), null));
        }
    }

    protected void addItems(List<SelectBoxItemDisplay2<E, E>> formattedModel) {
    }

    protected String getBlankText() {
        return "";
    }

    protected abstract E[] getEnumValues();

    protected Comparator<SelectBoxItemDisplay2<E, E>> getSortComparator() {
        return new EnumComparator();
    }

    protected String getText(E item) {
        return ((Enum)item).toString();
    }

    protected String getValue(E item) {
        return ((Enum)item).toString();
    }

    protected boolean hasBlankValue() {
        return false;
    }

    protected boolean isAllowed(E item) {
        return true;
    }

    protected SelectBoxItemDisplay2<E, E> makeSelectBoxItemDisplay(String value, String text, E data) {
        return new SelectBoxItemDisplay2<E, E>(value, text, data, data);
    }

    public void addBlankValue() {
        SelectBoxItemDisplay2<Object, Object> formattedItem = this.makeSelectBoxItemDisplay("", this.getBlankText(), null);
        this.formattedModel.add(0, formattedItem);
    }

    public List<SelectBoxItemDisplay2<E, E>> getList() {
        return this.formattedModel;
    }

    public void setList(List<SelectBoxItemDisplay2<E, E>> value) {
        this.formattedModel = value;
    }

    public void setSelectedFormattedValueWithConversionError(String value, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedFormattedValue(value);
        }
    }

    public void setSelectedValueWithConversionError(E key, String conversionErrorName) {
        Map conversionErrors;
        ConversionData conversionData;
        String rejectedValue = null;
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null && (conversionData = (ConversionData)(conversionErrors = actionContext.getConversionErrors()).get(conversionErrorName)) != null) {
            rejectedValue = (String)conversionData.getValue();
            this.setSelectedFormattedValue(rejectedValue);
        }
        if (rejectedValue == null) {
            this.setSelectedValue(key);
        }
    }

    public void setSelectedFormattedValue(String value) {
        SelectBoxItemDisplay2<E, E> item;
        if (this.selectedIndex > -1) {
            item = this.formattedModel.get(this.selectedIndex);
            item.setSelected(false);
        }
        this.selectedIndex = -1;
        if (value != null && value.length() > 0) {
            ListIterator<SelectBoxItemDisplay2<E, E>> iter = this.formattedModel.listIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (!item.getValue().equals(value)) continue;
                this.selectedIndex = iter.previousIndex();
                item.setSelected(true);
                found = true;
            }
        }
    }

    public void setSelectedValue(E value) {
        SelectBoxItemDisplay2<E, E> item;
        if (this.selectedIndex > -1) {
            item = this.formattedModel.get(this.selectedIndex);
            item.setSelected(false);
        }
        this.selectedIndex = -1;
        if (value != null) {
            ListIterator<SelectBoxItemDisplay2<E, E>> iter = this.formattedModel.listIterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                item = iter.next();
                if (!((Enum)item.getKey()).equals(value)) continue;
                this.selectedIndex = iter.previousIndex();
                item.setSelected(true);
                found = true;
            }
        }
    }

    public class EnumComparator
    implements Comparator<SelectBoxItemDisplay2<E, E>> {
        @Override
        public int compare(SelectBoxItemDisplay2<E, E> o1, SelectBoxItemDisplay2<E, E> o2) {
            Enum enum1 = (Enum)o1.getData();
            Enum enum2 = (Enum)o2.getData();
            return enum1.compareTo(enum2);
        }
    }
}

