/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import com.opensymphony.xwork2.ActionContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.matthewgreet.strutscommons.annotation.Form;
import name.matthewgreet.strutscommons.util.DefaultDisplayFormatter;
import name.matthewgreet.strutscommons.util.DefaultPolicyLookup;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import name.matthewgreet.strutscommons.util.PolicyLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrutsMiscellaneousLibrary {
    private static final Logger LOG = LogManager.getLogger(StrutsMiscellaneousLibrary.class);

    public static <T> void formatForm(Object form) {
        if (form != null) {
            Collection<Field> formFields = InterceptorCommonLibrary.getProperties(form.getClass());
            block4: for (Field formField : formFields) {
                if (!String.class.isAssignableFrom(formField.getType())) continue;
                try {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = formField.getAnnotations()) {
                        try {
                            InterceptorCommonLibrary.ConfiguredPolicy configuredPolicy = InterceptorCommonLibrary.getConfiguredPolicy(annotation, DefaultPolicyLookup.getInstance());
                            if (configuredPolicy.getAnnotationUsage() == InterceptorCommonLibrary.AnnotationUsage.CONVERT) {
                                InterceptorCommonLibrary.formatFormField(form, formFields, formField, configuredPolicy);
                                continue block4;
                            }
                            if (configuredPolicy.getAnnotationUsage() != InterceptorCommonLibrary.AnnotationUsage.COLLECTION_CONVERT) continue;
                            InterceptorCommonLibrary.formatCollectionFormField(form, formFields, formField, configuredPolicy);
                            continue block4;
                        }
                        catch (Exception e) {
                            LOG.error("Client supplied validator for form field failed   Struts action=" + ActionContext.getContext().getActionName() + "  field=" + formField.getName() + "  annotation=" + annotation.annotationType(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Security violation when accessing form field  Struts action=" + ActionContext.getContext().getActionName() + "  form=" + form.getClass() + "  field=" + formField.getName(), (Throwable)e);
                    return;
                }
            }
        }
    }

    public static void formatForms() {
        ActionContext actionContext = ActionContext.getContext();
        Object action = actionContext.getActionInvocation().getAction();
        Collection<Field> actionFields = InterceptorCommonLibrary.getProperties(action.getClass());
        for (Field actionField : actionFields) {
            boolean doForm = !InterceptorCommonLibrary.fieldReceivedStoredForm(actionField) && !InterceptorCommonLibrary.fieldIsNotForm(actionField);
            if (!doForm) continue;
            try {
                actionField.setAccessible(true);
                Form formAnnotation = actionField.getAnnotation(Form.class);
                if (formAnnotation != null && formAnnotation.disableFormatting()) continue;
                StrutsMiscellaneousLibrary.formatForm(actionField.get(action));
            }
            catch (Exception e) {
                LOG.error("Security violation when accessing form  Struts action=" + action.getClass() + "  field=" + actionField.getName(), (Throwable)e);
                return;
            }
        }
    }

    public static synchronized FormattedFormsResult getFormattedForms() {
        Map<String, Map<String, Object>> fakeForms = InterceptorCommonLibrary.getActionContextFormattedForms();
        FormattedFormsResult result = new FormattedFormsResult();
        for (Map.Entry<String, Map<String, Object>> fakeFormEntry : fakeForms.entrySet()) {
            String formName = fakeFormEntry.getKey();
            Map<String, Object> fakeForm = fakeFormEntry.getValue();
            for (Map.Entry<String, Object> fakeFieldEntry : fakeForm.entrySet()) {
                String fieldName = fakeFieldEntry.getKey();
                Object fakeField = fakeFieldEntry.getValue();
                if (List.class.isAssignableFrom(fakeField.getClass())) {
                    result.setMultipleValueFormField(formName, fieldName, (List)fakeField);
                    continue;
                }
                if (!String.class.isAssignableFrom(fakeField.getClass())) continue;
                result.setSingleValueFormField(formName, fieldName, (String)fakeField);
            }
        }
        return result;
    }

    public static void updateDisplay(Class<?> recordClass, Object record, Object display) {
        DefaultDisplayFormatter displayFormatter = new DefaultDisplayFormatter();
        displayFormatter.updateDisplay(recordClass, record, display);
    }

    public static void updateDisplayWithPolicyLookup(Class<?> recordClass, Object record, Object display, PolicyLookup policyLookup) {
        DefaultDisplayFormatter displayFormatter = new DefaultDisplayFormatter();
        displayFormatter.setPolicyLookup(policyLookup);
        displayFormatter.updateDisplay(recordClass, record, display);
    }

    public static class FormattedFormsResult
    implements Serializable {
        private static final long serialVersionUID = 5652867827375400916L;
        Map<String, Map<String, String>> singleValueFormFields = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, List<String>>> multipleValueFormFields = new HashMap<String, Map<String, List<String>>>();

        public List<String> getMultipleValueFormField(String formName, String fieldName) {
            List<Object> result;
            Map<String, List<String>> fakeForm = this.multipleValueFormFields.get(formName);
            if (fakeForm != null) {
                result = fakeForm.get(fieldName);
                if (result == null) {
                    result = new ArrayList();
                }
            } else {
                result = new ArrayList();
            }
            return result;
        }

        public void setMultipleValueFormField(String formName, String fieldName, List<String> formattedValues) {
            Map<String, List<String>> fakeForm = this.multipleValueFormFields.get(formName);
            if (fakeForm == null) {
                fakeForm = new HashMap<String, List<String>>();
                this.multipleValueFormFields.put(formName, fakeForm);
            }
            fakeForm.put(fieldName, formattedValues);
        }

        public String getSingleValueFormField(String formName, String fieldName) {
            String result;
            Map<String, String> fakeForm = this.singleValueFormFields.get(formName);
            if (fakeForm != null) {
                result = fakeForm.get(fieldName);
                if (result == null) {
                    result = "";
                }
            } else {
                result = "";
            }
            return result;
        }

        public void setSingleValueFormField(String formName, String fieldName, String formattedValue) {
            Map<String, String> fakeForm = this.singleValueFormFields.get(formName);
            if (fakeForm == null) {
                fakeForm = new HashMap<String, String>();
                this.singleValueFormFields.put(formName, fakeForm);
            }
            fakeForm.put(fieldName, formattedValue);
        }
    }
}

