/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import name.matthewgreet.strutscommons.util.IdListFinder;
import name.matthewgreet.strutscommons.util.KeyExtractor;
import name.matthewgreet.strutscommons.util.ListCacheListener;
import name.matthewgreet.strutscommons.util.ListCacheRecordComparator;
import name.matthewgreet.strutscommons.util.ListFinder;
import name.matthewgreet.strutscommons.util.ListSizeFinder;
import name.matthewgreet.strutscommons.util.PageByIdsFinder;
import name.matthewgreet.strutscommons.util.PageByIndexRangeFinder;
import name.matthewgreet.strutscommons.util.PageExtensionAssembler;
import name.matthewgreet.strutscommons.util.SingleItemFinder;

public class ListCache<M extends Serializable, K extends Serializable, T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -8481658486616110929L;
    private ListFinder<M, T> baseRecordListFinder;
    private boolean hasDetails;
    private IdListFinder<M, K> idListFinder;
    private UnaryOperator<T> itemDeepCopier;
    private SingleItemFinder<K, T> itemFinder;
    private ListCacheRecordComparator<T> itemSorter;
    private KeyExtractor<K, T> keyExtractor;
    private List<ItemData<K, T>> list;
    private Collection<ListCacheListener<T>> listeners;
    private ListFinder<M, T> listFinder;
    private ListSizeFinder<M> listSizeFinder;
    private ListCache<?, ?, M> masterList;
    private String name;
    private NotifyMode notifyMode;
    private PageByIdsFinder<K, T> pageByIdsFinder;
    private PageByIndexRangeFinder<M, T> pageByIndexRangeFinder;
    private PageExtensionAssembler<T> pageExtensionAssembler;
    private int pageSize;
    private PaginationMode paginationMode;
    private boolean reload;
    private boolean reSort;
    private int selectedIndex;

    public ListCache(ListCache<M, K, T> other, ListCache<?, ?, M> newMaster) throws Exception {
        this.baseRecordListFinder = other.getBaseRecordListFinder();
        this.hasDetails = other.getHasDetails();
        this.idListFinder = other.getIdListFinder();
        this.itemDeepCopier = other.getItemDeepCopier();
        this.itemFinder = other.getItemFinder();
        this.itemSorter = other.getItemSorter();
        this.keyExtractor = other.getKeyExtractor();
        this.list = new ArrayList<ItemData<K, T>>();
        for (ItemData<K, T> otherItem : other.list) {
            this.list.add(new ItemData<K, T>(otherItem, this.itemDeepCopier));
        }
        this.listeners = new ArrayList<ListCacheListener<T>>();
        this.listFinder = other.getListFinder();
        this.listSizeFinder = other.getListSizeFinder();
        this.masterList = newMaster;
        this.name = other.getName();
        this.notifyMode = NotifyMode.NONE;
        this.pageByIdsFinder = other.getPageByIdsFinder();
        this.pageByIndexRangeFinder = other.getPageByIndexRangeFinder();
        this.pageExtensionAssembler = other.getPageExtensionAssembler();
        this.pageSize = other.getPageSize();
        this.paginationMode = other.getPaginationMode();
        this.reload = other.getReload();
        this.reSort = other.getReSort();
        this.selectedIndex = other.getSelectedIndex();
    }

    public ListCache(ListCacheConfig<M, K, T> listCacheConfig, ListCache<?, ?, M> masterList) {
        this.baseRecordListFinder = listCacheConfig.getBaseRecordListFinder();
        this.hasDetails = listCacheConfig.getHasDetails();
        this.idListFinder = listCacheConfig.getIdListFinder();
        this.itemDeepCopier = listCacheConfig.getItemDeepCopier();
        this.itemFinder = listCacheConfig.getItemFinder();
        this.itemSorter = listCacheConfig.getItemSorter();
        this.keyExtractor = listCacheConfig.getKeyExtractor();
        this.list = new ArrayList<ItemData<K, T>>();
        this.listeners = new ArrayList<ListCacheListener<T>>();
        this.listFinder = listCacheConfig.getListFinder();
        this.listSizeFinder = listCacheConfig.getListSizeFinder();
        this.masterList = masterList;
        this.name = listCacheConfig.getName();
        this.notifyMode = NotifyMode.NONE;
        this.pageByIdsFinder = listCacheConfig.getPageByIdsFinder();
        this.pageByIndexRangeFinder = listCacheConfig.getPageByIndexRangeFinder();
        this.pageExtensionAssembler = listCacheConfig.getPageExtensionAssembler();
        this.pageSize = listCacheConfig.getPageSize();
        this.paginationMode = listCacheConfig.getPaginationMode();
        this.reload = true;
        this.reSort = false;
        this.selectedIndex = -1;
        if (masterList != null) {
            masterList.addListCacheListener(new SlaveListListener());
        }
    }

    private synchronized void addItemInternal(T item) throws IllegalStateException, Exception {
        this.checkReloadAccess();
        ItemData<K, T> itemData = new ItemData<K, T>();
        itemData.setId(this.keyExtractor.getKey(item));
        itemData.setItem(item);
        this.list.add(itemData);
        this.setSelectedIndexInternal(this.list.size() - 1);
        this.markChanged();
    }

    private void checkEntireListData() throws Exception {
        switch (this.paginationMode.ordinal()) {
            case 0: {
                this.checkEntireListDataByBaseRecords();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.checkEntireListDataByIds();
                break;
            }
            case 3: {
                this.checkEntireListDataByIndexRange();
            }
        }
    }

    private void checkEntireListDataByBaseRecords() throws Exception {
        ItemData<K, T> itemData;
        int i;
        int size = this.list.size();
        ArrayList<Serializable> loadingItems = new ArrayList<Serializable>();
        for (i = 0; i < size; ++i) {
            itemData = this.list.get(i);
            Serializable item = (Serializable)itemData.getItem();
            loadingItems.add(item);
        }
        this.pageExtensionAssembler.assemblePageExtensions(loadingItems);
        for (i = 0; i < size; ++i) {
            itemData = this.list.get(i);
            itemData.setPageExtensionReload(false);
        }
    }

    private void checkEntireListDataByIds() throws Exception {
        int index;
        ItemData<K, Serializable> itemData;
        int size = this.list.size();
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        HashMap<Serializable, Integer> loadingIds = new HashMap<Serializable, Integer>();
        for (int i = 0; i < size; ++i) {
            itemData = this.list.get(i);
            if (!itemData.getReload()) continue;
            ids.add((Serializable)itemData.getId());
            loadingIds.put((Serializable)itemData.getId(), i);
        }
        Collection<T> loadingItems = this.pageByIdsFinder.getItems(ids);
        boolean detailLoaded = this.pageByIdsFinder.getLoadsDetails();
        for (Serializable loadingItem : loadingItems) {
            K id = this.keyExtractor.getKey(loadingItem);
            index = (Integer)loadingIds.get(id);
            itemData = this.list.get(index);
            itemData.setDetailsReload(!detailLoaded);
            itemData.setItem(loadingItem);
            itemData.setPageExtensionReload(false);
            itemData.setReload(false);
        }
        ArrayList<Integer> removalIndices = new ArrayList<Integer>();
        for (Serializable loadingId : loadingIds.keySet()) {
            index = (Integer)loadingIds.get(loadingId);
            Serializable item = (Serializable)this.list.get(index).getItem();
            if (item != null) continue;
            removalIndices.add(index);
        }
        Collections.sort(removalIndices, Collections.reverseOrder());
        Iterator<Object> iterator = removalIndices.iterator();
        while (iterator.hasNext()) {
            int removeIndex = (Integer)iterator.next();
            this.list.remove(removeIndex);
        }
    }

    private void checkEntireListDataByIndexRange() throws Exception {
        int i;
        int size = this.list.size();
        int lowestNotLoaded = -1;
        int highestNotLoaded = -1;
        for (i = 0; i < size; ++i) {
            if (!this.list.get(i).getReload()) continue;
            if (lowestNotLoaded < 0) {
                lowestNotLoaded = i;
            }
            highestNotLoaded = i;
        }
        if (lowestNotLoaded > -1) {
            int rangeSize = highestNotLoaded - lowestNotLoaded + 1;
            Object selectedMaster = this.masterList == null ? null : (Object)super.getSelectedInternal();
            List<T> loadingItemList = this.pageByIndexRangeFinder.getItems(selectedMaster, lowestNotLoaded, highestNotLoaded);
            boolean detailLoaded = this.pageByIndexRangeFinder.getLoadsDetails();
            if (rangeSize > loadingItemList.size()) {
                this.list.subList(lowestNotLoaded + loadingItemList.size(), size).clear();
            }
            for (i = 0; i < loadingItemList.size() && i < rangeSize; ++i) {
                Serializable item = (Serializable)loadingItemList.get(i);
                ItemData<K, Serializable> itemData = this.list.get(i + lowestNotLoaded);
                itemData.setDetailsReload(!detailLoaded);
                itemData.setId(this.keyExtractor.getKey(item));
                itemData.setItem(item);
                itemData.setPageExtensionReload(false);
                itemData.setReload(false);
            }
        }
    }

    private void checkPageListData(int startIndex, int endIndex) throws Exception {
        switch (this.paginationMode.ordinal()) {
            case 0: {
                this.checkPageListDataByBaseRecords(startIndex, endIndex);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.checkPageListDataByIds(startIndex, endIndex);
                break;
            }
            case 3: {
                this.checkPageListDataByIndexRange(startIndex, endIndex);
            }
        }
    }

    private void checkPageListDataByBaseRecords(int startIndex, int endIndex) throws Exception {
        ItemData<K, T> itemData;
        int i;
        int size = this.list.size();
        int workingStartIndex = startIndex >= 0 && startIndex < size ? startIndex : 0;
        int workingEndIndex = endIndex >= 0 && endIndex < size ? endIndex : size - 1;
        ArrayList<Serializable> loadingItems = new ArrayList<Serializable>();
        for (i = workingStartIndex; i <= workingEndIndex; ++i) {
            itemData = this.list.get(i);
            Serializable item = (Serializable)itemData.getItem();
            if (!itemData.getPageExtensionReload()) continue;
            loadingItems.add(item);
        }
        if (loadingItems.size() > 0) {
            this.pageExtensionAssembler.assemblePageExtensions(loadingItems);
            for (i = workingStartIndex; i <= workingEndIndex; ++i) {
                itemData = this.list.get(i);
                itemData.setPageExtensionReload(false);
            }
        }
    }

    private void checkPageListDataByIds(int startIndex, int endIndex) throws Exception {
        boolean loadFailed;
        do {
            int index;
            ItemData<K, Serializable> itemData;
            loadFailed = false;
            int listSize = this.list.size();
            ArrayList<Serializable> ids = new ArrayList<Serializable>();
            HashMap<Serializable, Integer> loadingIds = new HashMap<Serializable, Integer>();
            for (int i = startIndex; i <= endIndex; ++i) {
                if (i < 0 || i > listSize - 1 || !(itemData = this.list.get(i)).getReload()) continue;
                ids.add((Serializable)itemData.getId());
                loadingIds.put((Serializable)itemData.getId(), i);
            }
            if (ids.size() <= 0) continue;
            Collection<T> loadingItems = this.pageByIdsFinder.getItems(ids);
            for (Serializable loadingItem : loadingItems) {
                K id = this.keyExtractor.getKey(loadingItem);
                index = (Integer)loadingIds.get(id);
                itemData = this.list.get(index);
                itemData.setDetailsReload(!this.pageByIdsFinder.getLoadsDetails());
                itemData.setItem(loadingItem);
                itemData.setReload(false);
                itemData.setPageExtensionReload(false);
            }
            ArrayList<Integer> removalIndices = new ArrayList<Integer>();
            for (Serializable loadingId : loadingIds.keySet()) {
                index = (Integer)loadingIds.get(loadingId);
                Serializable item = (Serializable)this.list.get(index).getItem();
                if (item != null) continue;
                removalIndices.add(index);
                loadFailed = true;
            }
            Collections.sort(removalIndices, Collections.reverseOrder());
            Iterator<Object> iterator = removalIndices.iterator();
            while (iterator.hasNext()) {
                int removalIndex = (Integer)iterator.next();
                this.list.remove(removalIndex);
            }
        } while (loadFailed);
    }

    private void checkPageListDataByIndexRange(int startIndex, int endIndex) throws Exception {
        int i;
        int listSize = this.list.size();
        int lowestNotLoaded = -1;
        int highestNotLoaded = -1;
        for (i = startIndex; i <= endIndex; ++i) {
            if (!this.list.get(i).getReload()) continue;
            if (lowestNotLoaded < 0) {
                lowestNotLoaded = i;
            }
            highestNotLoaded = i;
        }
        if (lowestNotLoaded > -1) {
            int rangeSize = highestNotLoaded - lowestNotLoaded + 1;
            Object selectedMaster = this.masterList == null ? null : (Object)super.getSelectedInternal();
            List<T> loadingItemList = this.pageByIndexRangeFinder.getItems(selectedMaster, lowestNotLoaded, highestNotLoaded);
            boolean detailLoaded = this.pageByIndexRangeFinder.getLoadsDetails();
            if (rangeSize > loadingItemList.size()) {
                this.list.subList(startIndex + loadingItemList.size(), listSize).clear();
            }
            for (i = 0; i < loadingItemList.size() && i < rangeSize; ++i) {
                Serializable item = (Serializable)loadingItemList.get(i);
                ItemData<K, Serializable> itemData = this.list.get(i + lowestNotLoaded);
                itemData.setDetailsReload(!detailLoaded);
                itemData.setId(this.keyExtractor.getKey(item));
                itemData.setItem(item);
                itemData.setPageExtensionReload(false);
                itemData.setReload(false);
            }
        }
    }

    private void checkReloadAccess() throws IllegalStateException {
        if (this.reload) {
            throw new IllegalStateException("Attempt to blindly set selected record for " + this.name + " list without accessing list first.");
        }
    }

    private void checkReloadItemDetail(int startIndex, int endIndex) throws Exception {
        HashSet<Integer> indicesToLoad = new HashSet<Integer>();
        for (int index = startIndex; index <= endIndex; ++index) {
            boolean reloadNeeded = this.getItemReloadNeeded(index);
            if (!reloadNeeded) continue;
            indicesToLoad.add(index);
        }
        if (indicesToLoad.size() > 0) {
            boolean reloadList;
            if (this.hasDetails && this.itemFinder == null) {
                throw new IllegalStateException("Single item finder for " + this.name + " list is not set but details need to be reloaded.");
            }
            if (this.itemFinder == null) {
                reloadList = true;
            } else {
                boolean bl = reloadList = !this.loadItemDetails(indicesToLoad);
            }
            if (reloadList) {
                this.loadList();
            }
        }
    }

    private void checkReloadItems(int startIndex, int endIndex) throws Exception {
        HashSet<Integer> indicesToLoad = new HashSet<Integer>();
        for (int index = startIndex; index <= endIndex; ++index) {
            ItemData<K, T> itemData = this.list.get(index);
            if (!itemData.getReload()) continue;
            indicesToLoad.add(index);
        }
        if (indicesToLoad.size() > 0) {
            boolean reloadList;
            if (this.itemFinder == null) {
                reloadList = true;
            } else {
                boolean bl = reloadList = !this.loadItemDetails(indicesToLoad);
            }
            if (reloadList) {
                this.loadList();
                this.checkSelectedIndex();
            }
        }
    }

    private synchronized void checkReloadState() throws Exception {
        if (this.reload) {
            this.loadList();
        } else {
            this.checkSort();
        }
    }

    private void checkSelectedIndex() {
        int size = this.list.size();
        if (this.selectedIndex >= size) {
            this.selectedIndex = size - 1;
            this.markChanged();
        } else if (this.selectedIndex < 0 && size > 0) {
            this.selectedIndex = 0;
            this.markChanged();
        }
    }

    private void checkSort() throws Exception {
        if (this.reSort && this.itemSorter != null) {
            switch (this.paginationMode.ordinal()) {
                case 0: {
                    if (!this.itemSorter.usesPageExtensionData()) break;
                    this.checkEntireListDataByBaseRecords();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.checkEntireListDataByIds();
                    break;
                }
                case 3: {
                    this.checkEntireListDataByIndexRange();
                }
            }
            Collections.sort(this.list, new ItemDataComparator(this.itemSorter));
            this.markChanged();
        }
        this.reSort = false;
    }

    private synchronized void forceReloadInternal() throws Exception {
        this.list.clear();
        this.reload = true;
        this.loadList();
    }

    private boolean getItemReloadNeeded(int index) {
        ItemData<K, T> itemData;
        boolean reloadNeeded = index >= 0 ? ((itemData = this.list.get(index)).getItem() == null || itemData.getReload() ? true : this.hasDetails && itemData.getDetailsReload()) : false;
        return reloadNeeded;
    }

    private synchronized List<T> getListInternal() throws Exception {
        this.checkReloadState();
        this.checkEntireListData();
        this.checkReloadItems(0, this.list.size() - 1);
        return this.getListUnchecked();
    }

    private List<T> getListUnchecked() {
        ArrayList<Serializable> result = new ArrayList<Serializable>(this.list.size());
        for (ItemData<K, T> itemData : this.list) {
            result.add((Serializable)itemData.getItem());
        }
        return result;
    }

    private synchronized List<T> getPageInternal() throws Exception {
        this.checkReloadState();
        if (this.list.size() > 0) {
            int pageNo = this.getPageNoInternal();
            pageNo = pageNo < 1 ? 1 : pageNo;
            int startIndex = (pageNo - 1) * this.pageSize;
            int endIndex = startIndex + this.pageSize - 1;
            endIndex = endIndex >= this.list.size() ? this.list.size() - 1 : endIndex;
            this.checkPageListData(startIndex, endIndex);
            startIndex = startIndex >= this.list.size() ? this.list.size() - 1 : startIndex;
            startIndex = startIndex < 0 ? 0 : startIndex;
            endIndex = endIndex >= this.list.size() ? this.list.size() - 1 : endIndex;
            this.checkReloadItems(startIndex, endIndex);
            return this.getListUnchecked().subList(startIndex, endIndex + 1);
        }
        return new ArrayList();
    }

    private int getPageNoInternal() throws Exception {
        if (this.selectedIndex > -1) {
            return this.selectedIndex / this.pageSize + 1;
        }
        return 0;
    }

    private synchronized List<T> getRangeInternal(int startIndex, int endIndex) throws Exception {
        this.checkReloadState();
        if (this.list.size() > 0) {
            int workingStart = startIndex;
            workingStart = workingStart < 0 ? 0 : workingStart;
            workingStart = workingStart >= this.list.size() ? this.list.size() - 1 : workingStart;
            workingStart = workingStart < 0 ? 0 : workingStart;
            int workingEnd = endIndex;
            workingEnd = workingEnd < 0 ? 0 : workingEnd;
            workingEnd = workingEnd >= this.list.size() ? this.list.size() - 1 : workingEnd;
            workingEnd = workingEnd < 0 ? 0 : workingEnd;
            this.checkPageListData(workingStart, workingEnd);
            workingStart = workingStart >= this.list.size() ? this.list.size() - 1 : workingStart;
            workingStart = workingStart < 0 ? 0 : workingStart;
            workingEnd = workingEnd >= this.list.size() ? this.list.size() - 1 : workingEnd;
            return this.getListUnchecked().subList(workingStart, workingEnd + 1);
        }
        return new ArrayList();
    }

    private synchronized T getSelectedInternal() throws Exception {
        this.checkReloadState();
        if (this.selectedIndex >= 0) {
            this.checkPageListData(this.selectedIndex, this.selectedIndex);
            this.checkReloadItemDetail(this.selectedIndex, this.selectedIndex);
            return (T)((Serializable)this.list.get(this.selectedIndex).getItem());
        }
        return null;
    }

    private boolean loadItemDetails(Collection<Integer> indices) throws Exception {
        boolean failed = false;
        for (int index : indices) {
            ItemData<K, T> itemData = this.list.get(index);
            T item = this.itemFinder.getItem((Serializable)itemData.getId());
            if (item != null) {
                itemData.setItem(item);
                itemData.setReload(false);
                itemData.setDetailsReload(false);
                this.markChanged();
                continue;
            }
            failed = true;
        }
        return !failed;
    }

    private void loadList() throws Exception {
        Object selectedMaster = this.masterList == null ? null : (Object)super.getSelectedInternal();
        switch (this.paginationMode.ordinal()) {
            case 0: {
                List<T> itemList = this.baseRecordListFinder.getList(selectedMaster);
                boolean pageExtensionsLoaded = this.baseRecordListFinder.getLoadsDetails();
                if (itemList == null) {
                    itemList = new ArrayList<T>();
                } else if (this.itemSorter != null) {
                    if (!pageExtensionsLoaded && this.itemSorter.usesPageExtensionData()) {
                        this.pageExtensionAssembler.assemblePageExtensions(itemList);
                    }
                    Collections.sort(itemList, this.itemSorter);
                }
                this.setList(itemList, pageExtensionsLoaded, this.baseRecordListFinder.getLoadsDetails());
                break;
            }
            case 1: {
                List<T> itemList = this.listFinder.getList(selectedMaster);
                if (itemList == null) {
                    itemList = new ArrayList<T>();
                } else if (this.itemSorter != null) {
                    Collections.sort(itemList, this.itemSorter);
                }
                this.setList(itemList, true, this.listFinder.getLoadsDetails());
                break;
            }
            case 2: {
                List<K> idList = this.idListFinder.getIds(selectedMaster);
                if (idList == null) {
                    idList = new ArrayList<K>();
                }
                this.setIdList(idList);
                if (this.itemSorter == null) break;
                this.checkEntireListDataByIds();
                Collections.sort(this.list, new ItemDataComparator(this.itemSorter));
                break;
            }
            case 3: {
                int listSize = this.listSizeFinder.getSize(selectedMaster);
                this.setListSize(listSize);
                if (this.itemSorter == null) break;
                this.checkEntireListDataByIndexRange();
                Collections.sort(this.list, new ItemDataComparator(this.itemSorter));
            }
        }
        this.markChanged();
    }

    private synchronized void markReloadInternal() {
        this.list.clear();
        this.reload = true;
        this.markChanged();
    }

    private synchronized void markReSortInternal() {
        this.reSort = true;
    }

    private synchronized T removeInternal(int index) throws IllegalStateException, Exception {
        Serializable result = null;
        this.checkReloadAccess();
        ItemData<K, T> itemData = this.list.get(index);
        if (itemData != null) {
            this.list.remove(index);
            this.checkSelectedIndex();
            result = (Serializable)itemData.getItem();
            this.markChanged();
        }
        return (T)result;
    }

    private synchronized T removeSelectedInternal() throws IllegalStateException, Exception {
        Serializable result;
        this.checkReloadAccess();
        if (this.selectedIndex >= 0) {
            result = (Serializable)this.list.get(this.selectedIndex).getItem();
            this.list.remove(this.selectedIndex);
            this.checkSelectedIndex();
            this.markChanged();
        } else {
            result = null;
        }
        return (T)result;
    }

    private synchronized void setBaseRecordListAndFinderInternal(List<T> list, ListFinder<M, T> baseRecordListFinder) {
        if (baseRecordListFinder == null) {
            throw new IllegalStateException("List finder for " + this.name + " list must be set with its list.");
        }
        this.setList(list, baseRecordListFinder.getLoadsDetails(), baseRecordListFinder.getLoadsDetails());
        this.baseRecordListFinder = baseRecordListFinder;
        this.idListFinder = null;
        this.listFinder = null;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.BASE_RECORD_LIST;
        this.markReSort();
        this.setSelectedIndexInternal(0);
        this.markChanged();
    }

    private void setBaseRecordListFinderInternal(ListFinder<M, T> baseRecordListFinder) {
        if (baseRecordListFinder == null) {
            throw new IllegalStateException("Base record list finder for " + this.name + " list must be set.");
        }
        this.setList(new ArrayList(), baseRecordListFinder.getLoadsDetails(), baseRecordListFinder.getLoadsDetails());
        this.baseRecordListFinder = baseRecordListFinder;
        this.idListFinder = null;
        this.listFinder = null;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.BASE_RECORD_LIST;
        this.markReloadInternal();
    }

    private synchronized void setIdList(List<K> ids) {
        this.reload = false;
        this.list = new ArrayList<ItemData<K, T>>(ids.size());
        for (Serializable id : ids) {
            ItemData itemData = new ItemData();
            itemData.setId(id);
            itemData.setItem(null);
            itemData.setPageExtensionReload(false);
            itemData.setReload(true);
            this.list.add(itemData);
        }
        this.checkSelectedIndex();
        this.markChanged();
    }

    private synchronized void setIdListAndFinderInternal(List<K> idList, IdListFinder<M, K> idListFinder) {
        if (idListFinder == null) {
            throw new IllegalStateException("Id list finder for " + this.name + " list must be set with its id list.");
        }
        this.setIdList(idList);
        this.baseRecordListFinder = null;
        this.idListFinder = idListFinder;
        this.listFinder = null;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.PAGE_BY_IDS;
        this.markReSortInternal();
        this.setSelectedIndexInternal(0);
        this.markChanged();
    }

    private synchronized void setIdListFinderInternal(IdListFinder<M, K> idListFinder) {
        if (idListFinder == null) {
            throw new IllegalStateException("Id list finder for " + this.name + " list must be set with its id list.");
        }
        this.setIdList(new ArrayList());
        this.baseRecordListFinder = null;
        this.idListFinder = idListFinder;
        this.listFinder = null;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.PAGE_BY_IDS;
        this.markReloadInternal();
    }

    private synchronized void setList(List<T> value, boolean pageExtensionsLoaded, boolean detailLoaded) {
        this.reload = false;
        this.list = new ArrayList<ItemData<K, T>>(value.size());
        for (Serializable item : value) {
            ItemData<K, Serializable> itemData = new ItemData<K, Serializable>();
            itemData.setDetailsReload(!detailLoaded);
            itemData.setId(this.keyExtractor.getKey(item));
            itemData.setItem(item);
            itemData.setPageExtensionReload(!pageExtensionsLoaded);
            itemData.setReload(false);
            this.list.add(itemData);
        }
        this.checkSelectedIndex();
        this.markChanged();
    }

    private synchronized void setListAndFinderInternal(List<T> list, ListFinder<M, T> listFinder) {
        if (listFinder == null) {
            throw new IllegalStateException("List finder for " + this.name + " list must be set with its list.");
        }
        this.setList(list, true, listFinder.getLoadsDetails());
        this.baseRecordListFinder = null;
        this.idListFinder = null;
        this.listFinder = listFinder;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.FULL_LIST;
        this.markReSort();
        this.setSelectedIndexInternal(0);
        this.markChanged();
    }

    private synchronized void setListFinderInternal(ListFinder<M, T> listFinder) {
        if (listFinder == null) {
            throw new IllegalStateException("List finder for " + this.name + " list must be set with its list.");
        }
        this.setList(new ArrayList(), true, listFinder.getLoadsDetails());
        this.baseRecordListFinder = null;
        this.idListFinder = null;
        this.listFinder = listFinder;
        this.listSizeFinder = null;
        this.pageByIndexRangeFinder = null;
        this.paginationMode = PaginationMode.FULL_LIST;
        this.markReloadInternal();
    }

    private synchronized void setListSize(int listSize) {
        this.reload = false;
        this.list = new ArrayList<ItemData<K, T>>(listSize);
        for (int i = 0; i < listSize; ++i) {
            ItemData itemData = new ItemData();
            itemData.setDetailsReload(true);
            itemData.setId(null);
            itemData.setItem(null);
            itemData.setPageExtensionReload(false);
            itemData.setReload(true);
            this.list.add(itemData);
        }
        this.checkSelectedIndex();
        this.markChanged();
    }

    private synchronized void setListSizeAndFinderInternal(int listSize, ListSizeFinder<M> listSizeFinder, PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
        if (listSizeFinder == null || pageByIndexRangeFinder == null) {
            throw new IllegalStateException("List size finder pr page by index tange finder for " + this.name + " list must be set with its list size.");
        }
        this.setListSize(listSize);
        this.baseRecordListFinder = null;
        this.idListFinder = null;
        this.listFinder = null;
        this.listSizeFinder = listSizeFinder;
        this.pageByIndexRangeFinder = pageByIndexRangeFinder;
        this.paginationMode = PaginationMode.PAGE_BY_INDEX_RANGE;
        this.markReSort();
        this.setSelectedIndexInternal(0);
        this.markChanged();
    }

    private synchronized void setListSizeFinderInternal(ListSizeFinder<M> listSizeFinder, PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
        if (listSizeFinder == null || pageByIndexRangeFinder == null) {
            throw new IllegalStateException("List size finder pr page by index tange finder for " + this.name + " list must be set with its list size.");
        }
        this.setListSize(0);
        this.baseRecordListFinder = null;
        this.idListFinder = null;
        this.listFinder = null;
        this.listSizeFinder = listSizeFinder;
        this.pageByIndexRangeFinder = pageByIndexRangeFinder;
        this.paginationMode = PaginationMode.PAGE_BY_INDEX_RANGE;
        this.markReloadInternal();
    }

    private synchronized void setSelectedInternal(T value) {
        this.checkReloadAccess();
        if (this.selectedIndex != -1) {
            this.setSelectedItemUnchecked(value);
        }
        this.markChanged();
    }

    private void setSelectedItemUnchecked(T item) {
        this.list.get(this.selectedIndex).setItem(item);
        this.markChanged();
    }

    private synchronized void setSelectedIndexInternal(int index) {
        this.checkReloadAccess();
        int oldIndex = this.selectedIndex;
        int size = this.list.size();
        this.selectedIndex = index >= size ? size - 1 : (index < 0 ? -1 : index);
        if (index != oldIndex) {
            this.markChanged();
        }
    }

    protected synchronized void markChanged() {
        if (this.notifyMode == NotifyMode.NONE) {
            this.notifyMode = NotifyMode.NOTIFY;
        }
    }

    protected void notifyChanged() {
        if (this.notifyMode == NotifyMode.NOTIFY) {
            try {
                this.notifyMode = NotifyMode.NOTIFYING;
                for (ListCacheListener<T> listener : this.listeners) {
                    listener.notifyChanged(this);
                }
            }
            finally {
                this.notifyMode = NotifyMode.NONE;
            }
        }
    }

    public void addListCacheListener(ListCacheListener<T> listener) {
        this.listeners.add(listener);
    }

    public void addItem(T item) throws IllegalStateException, Exception {
        this.addItemInternal(item);
        this.notifyChanged();
    }

    public void forceReload() throws Exception {
        this.forceReloadInternal();
        this.notifyChanged();
    }

    public ListFinder<M, T> getBaseRecordListFinder() {
        return this.baseRecordListFinder;
    }

    public boolean getHasDetails() {
        return this.hasDetails;
    }

    public IdListFinder<M, K> getIdListFinder() {
        return this.idListFinder;
    }

    public UnaryOperator<T> getItemDeepCopier() {
        return this.itemDeepCopier;
    }

    public SingleItemFinder<K, T> getItemFinder() {
        return this.itemFinder;
    }

    public ListCacheRecordComparator<T> getItemSorter() {
        return this.itemSorter;
    }

    public KeyExtractor<K, T> getKeyExtractor() {
        return this.keyExtractor;
    }

    public List<T> getList() throws Exception {
        List<T> result = this.getListInternal();
        this.notifyChanged();
        return result;
    }

    public Collection<ListCacheListener<T>> getListeners() {
        return this.listeners;
    }

    public ListFinder<M, T> getListFinder() {
        return this.listFinder;
    }

    public int getListSize() throws Exception {
        this.checkReloadState();
        this.notifyChanged();
        return this.list.size();
    }

    public ListSizeFinder<M> getListSizeFinder() {
        return this.listSizeFinder;
    }

    public ListCache<?, ?, M> getMasterList() {
        return this.masterList;
    }

    public String getName() {
        return this.name;
    }

    public List<T> getPage() throws Exception {
        List<T> result = this.getPageInternal();
        this.notifyChanged();
        return result;
    }

    public PageByIdsFinder<K, T> getPageByIdsFinder() {
        return this.pageByIdsFinder;
    }

    public PageByIndexRangeFinder<M, T> getPageByIndexRangeFinder() {
        return this.pageByIndexRangeFinder;
    }

    public PageExtensionAssembler<T> getPageExtensionAssembler() {
        return this.pageExtensionAssembler;
    }

    public int getPageNo() throws Exception {
        return this.getPageNoInternal();
    }

    public int getPageSize() throws Exception {
        return this.pageSize;
    }

    public PaginationMode getPaginationMode() {
        return this.paginationMode;
    }

    public List<T> getRange(int startIndex, int endIndex) throws Exception {
        List<T> result = this.getRangeInternal(startIndex, endIndex);
        this.notifyChanged();
        return result;
    }

    public boolean getReload() {
        return this.reload;
    }

    public boolean getReSort() {
        return this.reSort;
    }

    public T getSelected() throws Exception {
        T result = this.getSelectedInternal();
        this.notifyChanged();
        return result;
    }

    public synchronized T getSelectedNoDetail() throws Exception {
        this.checkReloadState();
        if (this.selectedIndex >= 0) {
            this.checkPageListData(this.selectedIndex, this.selectedIndex);
            return (T)((Serializable)this.list.get(this.selectedIndex).getItem());
        }
        return null;
    }

    public int getSelectedIndex() throws Exception {
        this.checkReloadState();
        this.notifyChanged();
        return this.selectedIndex;
    }

    public int getTotalPages() {
        return this.list.size() / this.pageSize + (this.list.size() % this.pageSize == 0 ? 0 : 1);
    }

    public void markReload() {
        this.markReloadInternal();
        this.notifyChanged();
    }

    public void markReSort() {
        this.markReSortInternal();
        this.notifyChanged();
    }

    public synchronized void markSelectedReload() {
        if (this.itemFinder != null) {
            ItemData<K, T> itemData = this.list.get(this.selectedIndex);
            itemData.setReload(true);
            this.notifyChanged();
        } else {
            this.markReload();
        }
    }

    public T remove(int index) throws IllegalStateException, Exception {
        T result = this.removeInternal(index);
        this.notifyChanged();
        return result;
    }

    public void removeListCacheListener(ListCacheListener<T> listener) {
        this.listeners.remove(listener);
    }

    public T removeSelected() throws IllegalStateException, Exception {
        T result = this.removeSelectedInternal();
        if (result != null) {
            this.notifyChanged();
        }
        return result;
    }

    public void setBaseRecordListAndFinder(List<T> list, ListFinder<M, T> baseRecordListFinder) {
        this.setBaseRecordListAndFinderInternal(list, baseRecordListFinder);
        this.notifyChanged();
    }

    public void setBaseRecordListFinder(ListFinder<M, T> baseRecordListFinder) {
        this.setBaseRecordListFinderInternal(baseRecordListFinder);
        this.notifyChanged();
    }

    public void setIdListAndFinder(List<K> idList, IdListFinder<M, K> idListFinder) {
        this.setIdListAndFinderInternal(idList, idListFinder);
        this.notifyChanged();
    }

    public void setIdListFinder(IdListFinder<M, K> idListFinder) {
        this.setIdListFinderInternal(idListFinder);
        this.notifyChanged();
    }

    public void setItemDeepCopier(UnaryOperator<T> itemDeepCopier) {
        this.itemDeepCopier = itemDeepCopier;
    }

    public void setItemFinder(SingleItemFinder<K, T> value) {
        this.itemFinder = value;
    }

    public void setItemSorter(ListCacheRecordComparator<T> itemSorter) {
        this.itemSorter = itemSorter;
    }

    public void setKeyExtractor(KeyExtractor<K, T> keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    public void setListAndFinder(List<T> list, ListFinder<M, T> listFinder) {
        this.setListAndFinderInternal(list, listFinder);
        this.notifyChanged();
    }

    public void setListFinder(ListFinder<M, T> listFinder) {
        this.setListFinderInternal(listFinder);
        this.notifyChanged();
    }

    public void setListSizeAndFinder(int listSize, ListSizeFinder<M> listSizeFinder, PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
        this.setListSizeAndFinderInternal(listSize, listSizeFinder, pageByIndexRangeFinder);
        this.notifyChanged();
    }

    public void setListSizeFinder(ListSizeFinder<M> listSizeFinder, PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
        this.setListSizeFinderInternal(listSizeFinder, pageByIndexRangeFinder);
        this.notifyChanged();
    }

    public void setPageByIdsFinder(PageByIdsFinder<K, T> value) {
        this.pageByIdsFinder = value;
    }

    public void setPageExtensionAssembler(PageExtensionAssembler<T> pageExtensionAssembler) {
        this.pageExtensionAssembler = pageExtensionAssembler;
    }

    public void setPageNo(int pageNo) {
        this.setSelectedIndexInternal((pageNo - 1) * this.pageSize);
        this.notifyChanged();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSelected(T value) {
        this.setSelectedInternal(value);
        this.notifyChanged();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndexInternal(index);
        this.notifyChanged();
    }

    private static class ItemData<K, T>
    implements Serializable {
        private static final long serialVersionUID = 2092750648185163932L;
        private boolean detailsReload;
        private K id;
        private T item;
        private boolean pageExtensionReload;
        private boolean reload;

        public ItemData() {
            this.detailsReload = true;
            this.id = null;
            this.item = null;
            this.pageExtensionReload = false;
            this.reload = false;
        }

        public ItemData(ItemData<K, T> other, UnaryOperator<T> itemDeepCopier) {
            this.detailsReload = other.detailsReload;
            this.id = other.id;
            this.item = itemDeepCopier != null ? itemDeepCopier.apply(other.item) : other.item;
            this.pageExtensionReload = other.pageExtensionReload;
            this.reload = other.reload;
        }

        public boolean getDetailsReload() {
            return this.detailsReload;
        }

        public void setDetailsReload(boolean value) {
            this.detailsReload = value;
        }

        public K getId() {
            return this.id;
        }

        public void setId(K value) {
            this.id = value;
        }

        public T getItem() {
            return this.item;
        }

        public void setItem(T value) {
            this.item = value;
        }

        public boolean getPageExtensionReload() {
            return this.pageExtensionReload;
        }

        public void setPageExtensionReload(boolean pageExtensionReload) {
            this.pageExtensionReload = pageExtensionReload;
        }

        public boolean getReload() {
            return this.reload;
        }

        public void setReload(boolean value) {
            this.reload = value;
        }
    }

    public static enum NotifyMode {
        NONE,
        NOTIFY,
        NOTIFYING;

    }

    public static enum PaginationMode {
        BASE_RECORD_LIST,
        FULL_LIST,
        PAGE_BY_IDS,
        PAGE_BY_INDEX_RANGE;

    }

    public static class ListCacheConfig<M extends Serializable, K extends Serializable, T extends Serializable> {
        private ListFinder<M, T> baseRecordListFinder;
        private boolean hasDetails = false;
        private IdListFinder<M, K> idListFinder = null;
        private UnaryOperator<T> itemDeepCopier = null;
        private SingleItemFinder<K, T> itemFinder = null;
        private ListCacheRecordComparator<T> itemSorter = null;
        private KeyExtractor<K, T> keyExtractor = null;
        private ListFinder<M, T> listFinder = null;
        private ListSizeFinder<M> listSizeFinder = null;
        private String name;
        private PageByIdsFinder<K, T> pageByIdsFinder = null;
        private PageByIndexRangeFinder<M, T> pageByIndexRangeFinder = null;
        private PageExtensionAssembler<T> pageExtensionAssembler = null;
        private int pageSize = 10;
        private PaginationMode paginationMode = PaginationMode.FULL_LIST;

        public ListFinder<M, T> getBaseRecordListFinder() {
            return this.baseRecordListFinder;
        }

        public void setBaseRecordListFinder(ListFinder<M, T> value) {
            this.baseRecordListFinder = value;
        }

        public boolean getHasDetails() {
            return this.hasDetails;
        }

        public void setHasDetails(boolean hasDetails) {
            this.hasDetails = hasDetails;
        }

        public IdListFinder<M, K> getIdListFinder() {
            return this.idListFinder;
        }

        public void setIdListFinder(IdListFinder<M, K> value) {
            this.idListFinder = value;
        }

        public UnaryOperator<T> getItemDeepCopier() {
            return this.itemDeepCopier;
        }

        public void setItemDeepCopier(UnaryOperator<T> itemDeepCopier) {
            this.itemDeepCopier = itemDeepCopier;
        }

        public SingleItemFinder<K, T> getItemFinder() {
            return this.itemFinder;
        }

        public void setItemFinder(SingleItemFinder<K, T> itemFinder) {
            this.itemFinder = itemFinder;
        }

        public ListCacheRecordComparator<T> getItemSorter() {
            return this.itemSorter;
        }

        public void setItemSorter(ListCacheRecordComparator<T> value) {
            this.itemSorter = value;
        }

        public KeyExtractor<K, T> getKeyExtractor() {
            return this.keyExtractor;
        }

        public void setKeyExtractor(KeyExtractor<K, T> keyExtractor) {
            this.keyExtractor = keyExtractor;
        }

        public ListFinder<M, T> getListFinder() {
            return this.listFinder;
        }

        public void setListFinder(ListFinder<M, T> value) {
            this.listFinder = value;
        }

        public ListSizeFinder<M> getListSizeFinder() {
            return this.listSizeFinder;
        }

        public void setListSizeFinder(ListSizeFinder<M> listSizeFinder) {
            this.listSizeFinder = listSizeFinder;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public PageByIdsFinder<K, T> getPageByIdsFinder() {
            return this.pageByIdsFinder;
        }

        public void setPageByIdsFinder(PageByIdsFinder<K, T> value) {
            this.pageByIdsFinder = value;
        }

        public PageByIndexRangeFinder<M, T> getPageByIndexRangeFinder() {
            return this.pageByIndexRangeFinder;
        }

        public void setPageByIndexRangeFinder(PageByIndexRangeFinder<M, T> pageByIndexRangeFinder) {
            this.pageByIndexRangeFinder = pageByIndexRangeFinder;
        }

        public PageExtensionAssembler<T> getPageExtensionAssembler() {
            return this.pageExtensionAssembler;
        }

        public void setPageExtensionAssembler(PageExtensionAssembler<T> pageExtensionAssembler) {
            this.pageExtensionAssembler = pageExtensionAssembler;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public PaginationMode getPaginationMode() {
            return this.paginationMode;
        }

        public void setPaginationMode(PaginationMode paginationMode) {
            this.paginationMode = paginationMode;
        }
    }

    private class SlaveListListener
    implements ListCacheListener<M> {
        private static final long serialVersionUID = -1080730371566520579L;

        @Override
        public void notifyChanged(ListCache<?, ?, M> listCache) {
            ListCache.this.markReloadInternal();
        }
    }

    private static class ItemDataComparator<K, T>
    implements Comparator<ItemData<K, T>> {
        private Comparator<T> itemComparator;

        public ItemDataComparator(Comparator<T> itemComparator) {
            this.itemComparator = itemComparator;
        }

        @Override
        public int compare(ItemData<K, T> o1, ItemData<K, T> o2) {
            return this.itemComparator.compare(o1.getItem(), o2.getItem());
        }
    }
}

