/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.policy.AbstractDefaultConverterSupport;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegerConverter
extends AbstractDefaultConverterSupport<IntegerConversion, Integer> {
    private static final Logger LOG = LogManager.getLogger(IntegerConverter.class);
    @IntegerConversion
    private static boolean annotationPlaceholder;

    @Override
    protected IntegerConversion makeDefaultAnnotation() {
        try {
            return IntegerConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(IntegerConversion.class);
        }
        catch (Exception e) {
            LOG.error("Creation of default annotation failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String format(Integer unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public Required.MessageType getMessageType() {
        return ((IntegerConversion)this.getAnnotation()).messageType();
    }

    @Override
    public String getMessage() {
        return ((IntegerConversion)this.getAnnotation()).message();
    }

    @Override
    public String getMessageKey() {
        return ((IntegerConversion)this.getAnnotation()).messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return ((IntegerConversion)this.getAnnotation()).parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<? extends Integer> recipientClass) throws Exception {
        try {
            int parsedValue = Integer.parseInt(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

    @Override
    public boolean getProcessNoValue() {
        return false;
    }
}

