/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.policy;

import java.util.Collection;
import name.matthewgreet.strutscommons.annotation.Required;

public class ConversionResult<T> {
    private boolean success;
    private T parsedValue;
    private Collection<T> parsedCollectionValue;
    public String message;
    public String messageKey;
    public Required.MessageType messageType;

    public static <T> ConversionResult<T> makeSkippedCollectionResult(Collection<T> emptyCollection) {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(true);
        result.setParsedCollectionValue(emptyCollection);
        return result;
    }

    public static <T> ConversionResult<T> makeSkippedResult() {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(true);
        return result;
    }

    public static <T> ConversionResult<T> makeSuccessCollectionResult(Collection<T> parsedValue) {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(true);
        result.setParsedCollectionValue(parsedValue);
        return result;
    }

    public static <T> ConversionResult<T> makeSuccessResult(T parsedValue) {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(true);
        result.setParsedValue(parsedValue);
        return result;
    }

    public static <T> ConversionResult<T> makeFailureResult() {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(false);
        return result;
    }

    public static <T> ConversionResult<T> makeFailureWithMessageResult(String message, Required.MessageType messageType) {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(false);
        result.setMessage(message);
        result.setMessageType(messageType);
        return result;
    }

    public static <T> ConversionResult<T> makeFailureWithMessageKeyResult(String messageKey, Required.MessageType messageType) {
        ConversionResult<T> result = new ConversionResult<T>();
        result.setSuccess(false);
        result.setMessageKey(messageKey);
        result.setMessageType(messageType);
        return result;
    }

    public ConversionResult() {
        this.success = false;
        this.parsedValue = null;
        this.parsedCollectionValue = null;
        this.message = null;
        this.messageKey = null;
        this.messageType = null;
    }

    public ConversionResult(boolean success, T parsedValue, Collection<T> parsedCollectionValue, String message, String messageKey, Required.MessageType messageType) {
        this.success = success;
        this.parsedValue = parsedValue;
        this.parsedCollectionValue = parsedCollectionValue;
        this.message = message;
        this.messageKey = messageKey;
        this.messageType = messageType;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getParsedValue() {
        return this.parsedValue;
    }

    public void setParsedValue(T parsedValue) {
        this.parsedValue = parsedValue;
    }

    public Collection<T> getParsedCollectionValue() {
        return this.parsedCollectionValue;
    }

    public void setParsedCollectionValue(Collection<T> parsedCollectionValue) {
        this.parsedCollectionValue = parsedCollectionValue;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Required.MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(Required.MessageType messageType) {
        this.messageType = messageType;
    }
}

