/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import name.matthewgreet.strutscommons.annotation.Form;
import name.matthewgreet.strutscommons.interceptor.FormStoreInterceptor;
import name.matthewgreet.strutscommons.util.InterceptorCommonLibrary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class FormRetrieveInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6513506646328167140L;
    private Logger LOG = LogManager.getLogger(FormRetrieveInterceptor.class);
    private boolean disabled;

    private static Collection<Field> getProperties(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    private String getFullURL() {
        if (ServletActionContext.getRequest().getQueryString() != null) {
            return ServletActionContext.getRequest().getRequestURL().append('?').append(ServletActionContext.getRequest().getQueryString()).toString();
        }
        return ServletActionContext.getRequest().getRequestURL().toString();
    }

    protected void addConversionErrors(ActionInvocation invocation, FormStoreInterceptor.StoredForm storedForm, Field field) throws Exception {
        String fieldName = field.getName();
        for (Map.Entry<String, ConversionData> entry : storedForm.getConversionErrors().entrySet()) {
            String propertyName = fieldName + "." + entry.getKey();
            invocation.getInvocationContext().getConversionErrors().put(propertyName, entry.getValue());
        }
    }

    protected void deleteStoredForm() {
        ActionContext.getContext().getSession().remove(FormStoreInterceptor.SESSION_STORED_FORM);
    }

    protected boolean fieldReceives(Class<?> actionClass, Field field, FormStoreInterceptor.StoredForm storedForm) {
        Class[] processors;
        Form.Reception reception;
        if (!field.getType().isAssignableFrom(storedForm.getForm().getClass())) {
            return false;
        }
        if (field.getAnnotation(Form.class) != null) {
            Form formAnnotation = field.getAnnotation(Form.class);
            reception = formAnnotation.reception();
            processors = formAnnotation.processors();
        } else {
            reception = Form.Reception.ERROR;
            processors = new Class[]{};
        }
        boolean result = false;
        switch (reception) {
            case NEVER: {
                result = false;
                break;
            }
            case ERROR: {
                result = storedForm.getInvalid();
                break;
            }
            case SUCCESS: {
                result = !storedForm.getInvalid();
                break;
            }
            case ALWAYS: {
                result = true;
            }
        }
        if (result && processors.length > 0) {
            result = false;
            for (Class processor : processors) {
                if (!processor.isAssignableFrom(storedForm.getProcessor())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void injectForm(ActionInvocation invocation, FormStoreInterceptor.StoredForm storedForm, Field field) throws Exception {
        field.setAccessible(true);
        field.set(invocation.getAction(), storedForm.getForm());
    }

    protected void restoreForm(ActionInvocation invocation, FormStoreInterceptor.StoredForm storedForm) {
        Class<?> actionClass = invocation.getAction().getClass();
        Collection<Field> fields = FormRetrieveInterceptor.getProperties(actionClass);
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : fields) {
            boolean receive = this.fieldReceives(actionClass, field, storedForm);
            if (!receive) continue;
            try {
                this.injectForm(invocation, storedForm, field);
                this.addConversionErrors(invocation, storedForm, field);
                fieldNames.add(field.getName());
            }
            catch (Exception e) {
                this.LOG.error("Set stored form of Struts action member variable failed  Struts action=" + invocation.getAction().getClass() + "  field=" + field.getName(), (Throwable)e);
            }
        }
        storedForm.setOwningURL(this.getFullURL());
        storedForm.setOwningActionClass(actionClass);
        storedForm.setOwningActionFieldNames(fieldNames);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        FormStoreInterceptor.StoredForm storedForm;
        if (!this.disabled && (storedForm = InterceptorCommonLibrary.getStoredForm()) != null) {
            if (storedForm.getOwningURL() == null || storedForm.getOwningURL().equals(this.getFullURL())) {
                this.restoreForm(invocation, storedForm);
            } else {
                this.deleteStoredForm();
            }
        }
        return invocation.invoke();
    }
}

