/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import name.matthewgreet.strutscommons.action.BrowserTabAware2;
import name.matthewgreet.strutscommons.action.BrowserTabSession;
import name.matthewgreet.strutscommons.action.BrowserTabSessionImpl;
import name.matthewgreet.strutscommons.util.ServletLibrary;

public class BrowserTabInterceptor2
extends AbstractInterceptor {
    private static final long serialVersionUID = -1555224920319813415L;
    private boolean disabled;

    protected AttributeCloneAction attributeCloneAction(BrowserTabAware2 browserTabAware, ActionInvocation invocation, String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            return AttributeCloneAction.NULL;
        }
        Class<?> valueClass = attributeValue.getClass();
        try {
            valueClass.getConstructor(valueClass);
            return AttributeCloneAction.COPY_CONSTRUCTOR;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            if (attributeValue instanceof Cloneable) {
                return AttributeCloneAction.CLONE;
            }
            return AttributeCloneAction.COPY_REFERENCE;
        }
    }

    protected boolean attributeFromOldTabToNewTabClone(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, Map.Entry<String, Object> oldAttributeEntry) {
        if (oldAttributeEntry.getValue() instanceof Cloneable) {
            try {
                Method cloneMethod = oldAttributeEntry.getValue().getClass().getMethod("clone", new Class[0]);
                newBrowserTabSession.setAttribute(oldAttributeEntry.getKey(), cloneMethod.invoke(oldAttributeEntry.getValue(), new Object[0]));
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean attributeFromOldTabToNewTabCopyConstructor(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, Map.Entry<String, Object> oldAttributeEntry) {
        try {
            Class<?> valueClass = oldAttributeEntry.getValue().getClass();
            Constructor<?> copyConstructor = valueClass.getConstructor(valueClass);
            Object newValue = copyConstructor.newInstance(oldAttributeEntry.getValue());
            newBrowserTabSession.setAttribute(oldAttributeEntry.getKey(), newValue);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    protected boolean attributeFromOldTabToNewTabCopyReference(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, Map.Entry<String, Object> oldAttributeEntry) {
        newBrowserTabSession.setAttribute(oldAttributeEntry.getKey(), oldAttributeEntry.getValue());
        return true;
    }

    protected boolean attributeFromOldTabToNewTabIgnore(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, Map.Entry<String, Object> oldAttributeEntry) {
        return true;
    }

    protected boolean attributeFromOldTabToNewTabNull(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession, Map.Entry<String, Object> oldAttributeEntry) {
        newBrowserTabSession.setAttribute(oldAttributeEntry.getKey(), oldAttributeEntry.getValue());
        return true;
    }

    protected void attributesFromOldTabToNewTab(BrowserTabAware2 browserTabAware, ActionInvocation invocation, BrowserTabSession oldBrowserTabSession, BrowserTabSession newBrowserTabSession) {
        HashSet<String> attributeFailures = new HashSet<String>();
        HashSet<String> attributeIgnores = new HashSet<String>();
        browserTabAware.copyAttributesFromOldTabToNewTab(oldBrowserTabSession, newBrowserTabSession, attributeIgnores, attributeFailures);
        Map<String, Object> oldPrivateMap = oldBrowserTabSession.getPrivateAttributeMap();
        Map<String, Object> newPrivateMap = newBrowserTabSession.getPrivateAttributeMap();
        for (Map.Entry<String, Object> oldAttributeEntry : oldPrivateMap.entrySet()) {
            String oldAttributeName = oldAttributeEntry.getKey();
            if (attributeIgnores.contains(oldAttributeName) || newPrivateMap.containsKey(oldAttributeName)) continue;
            AttributeCloneAction attributeCloneAction = this.attributeCloneAction(browserTabAware, invocation, oldAttributeName, oldAttributeEntry.getValue());
            boolean success = true;
            switch (attributeCloneAction.ordinal()) {
                case 0: {
                    success = this.attributeFromOldTabToNewTabClone(browserTabAware, invocation, oldBrowserTabSession, newBrowserTabSession, oldAttributeEntry);
                    break;
                }
                case 1: {
                    success = this.attributeFromOldTabToNewTabCopyConstructor(browserTabAware, invocation, oldBrowserTabSession, newBrowserTabSession, oldAttributeEntry);
                    break;
                }
                case 2: {
                    success = this.attributeFromOldTabToNewTabCopyReference(browserTabAware, invocation, oldBrowserTabSession, newBrowserTabSession, oldAttributeEntry);
                    break;
                }
                case 3: {
                    success = this.attributeFromOldTabToNewTabIgnore(browserTabAware, invocation, oldBrowserTabSession, newBrowserTabSession, oldAttributeEntry);
                    break;
                }
                case 4: {
                    success = this.attributeFromOldTabToNewTabNull(browserTabAware, invocation, oldBrowserTabSession, newBrowserTabSession, oldAttributeEntry);
                }
            }
            if (success) continue;
            attributeFailures.add(oldAttributeName);
        }
        browserTabAware.handleAttributeFailures(oldBrowserTabSession, newBrowserTabSession, attributeFailures);
    }

    protected String getOldTabId(ActionInvocation invocation) {
        HttpServletRequest request = invocation.getInvocationContext().getServletRequest();
        Cookie[] cookies = request.getCookies();
        String result = ServletLibrary.getBrowserOldTabId(cookies);
        result = result != null ? result : "";
        return result;
    }

    protected String getTabId(ActionInvocation invocation) {
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        String result = ServletLibrary.getGuaranteedBrowserTabId(request, response);
        return result;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.disabled && invocation.getAction() instanceof BrowserTabAware2) {
            String tabId = this.getTabId(invocation);
            String oldTabId = this.getOldTabId(invocation);
            BrowserTabSessionImpl browserTabSession = new BrowserTabSessionImpl(invocation.getInvocationContext().getServletRequest().getSession(), tabId);
            BrowserTabAware2 browserTabAware = (BrowserTabAware2)invocation.getAction();
            if (oldTabId.length() > 0 && !oldTabId.equals(tabId)) {
                BrowserTabSessionImpl oldBrowserTabSession = new BrowserTabSessionImpl(invocation.getInvocationContext().getServletRequest().getSession(), oldTabId);
                this.attributesFromOldTabToNewTab(browserTabAware, invocation, oldBrowserTabSession, browserTabSession);
            }
            browserTabAware.setBrowserTabSession(browserTabSession);
        }
        String result = invocation.invoke();
        return result;
    }

    public static enum AttributeCloneAction {
        CLONE,
        COPY_CONSTRUCTOR,
        COPY_REFERENCE,
        IGNORE,
        NULL;

    }
}

