/*
 * Decompiled with CFR 0.152.
 */
package name.matthewgreet.strutscommons.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import name.matthewgreet.strutscommons.action.AbstractFormDrivenActionSupport;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.ListCacheRecordComparator;
import name.matthewgreet.strutscommons.util.ListFinder;

public abstract class AbstractFindListActionSupport<M extends Serializable, T extends Serializable, F extends AbstractForm>
extends AbstractFormDrivenActionSupport<F> {
    private static final long serialVersionUID = 7571697364740160930L;

    protected abstract FindListResponse<M, T> getFindCommand(M var1) throws Exception;

    protected abstract FindListConfig getFindListConfig();

    protected ListCacheRecordComparator<T> getItemSorter() {
        return null;
    }

    protected abstract ListCache<M, ?, T> getListCache();

    protected abstract ListCache<?, ?, M> getMasterListCache();

    protected String translateFinderException(ListFinder<M, T> finderCommand, Exception e) {
        return null;
    }

    public String execute() throws Exception {
        FindListConfig config = this.getFindListConfig();
        FindListResponse<Object, T> findResponse = null;
        ListFinder<Object, T> finderCommand = null;
        String errorMessage = null;
        ListCache<?, ?, M> masterListCache = this.getMasterListCache();
        ListCache<Object, ?, T> listCache = this.getListCache();
        try {
            Object selectedMaster = masterListCache != null && masterListCache != listCache ? (Object)masterListCache.getSelected() : null;
            findResponse = this.getFindCommand(selectedMaster);
            if (!findResponse.getRejected()) {
                finderCommand = findResponse.getFinderCommand();
                List<T> list = findResponse.getList() != null ? findResponse.getList() : finderCommand.getList(selectedMaster);
                if (list == null) {
                    list = new ArrayList<T>();
                }
                if (!config.getRejectNoMatch() || list.size() > 0) {
                    listCache.setListAndFinder(list, finderCommand);
                    ListCacheRecordComparator<T> itemSorter = this.getItemSorter();
                    if (itemSorter != null) {
                        listCache.setItemSorter(itemSorter);
                    }
                } else {
                    this.addActionError(config.getRejectMessage());
                }
            }
        }
        catch (Exception e) {
            if (finderCommand != null) {
                errorMessage = this.translateFinderException(finderCommand, e);
            }
            if (errorMessage == null || errorMessage.length() == 0) {
                errorMessage = "System failure: " + e.getMessage();
            }
            this.getLogger().error(errorMessage, (Throwable)e);
            this.addActionError(errorMessage);
        }
        if (findResponse != null) {
            for (String message : findResponse.getMessages()) {
                this.addActionMessage(message);
            }
            for (String errorMessage2 : findResponse.getErrors()) {
                this.addActionError(errorMessage2);
            }
            if (!findResponse.getRejected()) {
                return findResponse.getSuccessResultName();
            }
            return findResponse.getFailureResultName();
        }
        return "error";
    }

    public static class FindListConfig {
        private boolean rejectNoMatch = false;
        private String rejectMessage = "No results found";

        public boolean getRejectNoMatch() {
            return this.rejectNoMatch;
        }

        public void setRejectNoMatch(boolean value) {
            this.rejectNoMatch = value;
        }

        public String getRejectMessage() {
            return this.rejectMessage;
        }

        public void setRejectMessage(String value) {
            this.rejectMessage = value;
        }
    }

    public static class FindListResponse<M extends Serializable, T extends Serializable> {
        private boolean rejected = true;
        private String failureResultName = "input";
        private String successResultName = "success";
        private ListFinder<M, T> finderCommand;
        private List<T> list = null;
        private Collection<String> errors = new ArrayList<String>();
        private Collection<String> messages = new ArrayList<String>();

        public static <M extends Serializable, T extends Serializable> FindListResponse<M, T> makeFailureResponse(String message) {
            FindListResponse<M, T> result = new FindListResponse<M, T>();
            result.addErrorMessage(message);
            return result;
        }

        public static <M extends Serializable, T extends Serializable> FindListResponse<M, T> makeSuccessResponse(ListFinder<M, T> finderCommand) {
            FindListResponse<M, T> result = new FindListResponse<M, T>(finderCommand);
            return result;
        }

        public static <M extends Serializable, T extends Serializable> FindListResponse<M, T> makeSuccessWithListResponse(ListFinder<M, T> finderCommand, List<T> list) {
            FindListResponse<M, T> result = new FindListResponse<M, T>(finderCommand);
            result.setList(list);
            return result;
        }

        public FindListResponse() {
            this.rejected = true;
        }

        public FindListResponse(ListFinder<M, T> finderCommand) {
            this.rejected = false;
            this.finderCommand = finderCommand;
        }

        public boolean getRejected() {
            return this.rejected;
        }

        public ListFinder<M, T> getFinderCommand() {
            return this.finderCommand;
        }

        public String getFailureResultName() {
            return this.failureResultName;
        }

        public void setFailureResultName(String value) {
            this.failureResultName = value;
        }

        public String getSuccessResultName() {
            return this.successResultName;
        }

        public void setSuccessResultName(String value) {
            this.successResultName = value;
        }

        public List<T> getList() {
            return this.list;
        }

        public void setList(List<T> list) {
            this.list = list;
        }

        public Collection<String> getErrors() {
            return this.errors;
        }

        public Collection<String> getMessages() {
            return this.messages;
        }

        public void addErrorMessage(String text) {
            this.errors.add(text);
        }

        public void addInfoMessage(String text) {
            this.messages.add(text);
        }
    }
}

