package name.matthewgreet.strutscommons.policy;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

import name.matthewgreet.strutscommons.annotation.ToStartOfDay;


public class ToStartOfDayAdjuster extends AbstractPostConversionAdjusterSupport<ToStartOfDay,Date> {

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public Class<Date> getRecipientClass() {
        return Date.class;
    }

    @Override
    public Date adjust(Date formValue) throws Exception {
        Calendar calendar;

        calendar = new GregorianCalendar();
        calendar.setTime(formValue);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        return calendar.getTime();
    }

}
