package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;

import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;


/**
 * Base interface for form field converters, validators and adjusters used by {@link AnnotationValidationInterceptor} 
 * and {@link AnnotationValidationInterceptor2}. 
 */
@SuppressWarnings("deprecation")
public interface Policy<A extends Annotation> {
    /**
     * Returns annotation that configures this policy.
     */
    public A getAnnotation();
    
    /**
     * Sets annotation that configures this policy.
     */
    public void setAnnotation(A annotation);
    
}
