package name.matthewgreet.strutscommons.policy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class IntegerConverter extends AbstractDefaultConverterSupport<IntegerConversion,Integer> {
    private static final Logger LOG = LogManager.getLogger(IntegerConverter.class);
    
    @IntegerConversion
    private static boolean annotationPlaceholder;

	@Override
	protected IntegerConversion makeDefaultAnnotation() {
		try {
			return IntegerConverter.class.getDeclaredField("annotationPlaceholder").getAnnotation(IntegerConversion.class);
		}
    	catch (Exception e) {
			LOG.error("Creation of default annotation failed", e);
			return null;
		}
	}

    @Override
    public String format(Integer unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Integer> getRecipientClass() {
        return Integer.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Integer> convert(String formValue, Class<? extends Integer> recipientClass) throws Exception {
        int parsedValue;
        
        try {
            parsedValue = Integer.parseInt(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
