package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;
import java.util.Collection;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;

/**
 * Interface for form field validators used by {@link AnnotationValidationInterceptor} and 
 * {@link AnnotationValidationInterceptor2} that convert from string values to collections and vice versa. 
 */
@SuppressWarnings("deprecation")
public interface CollectionConverter<A extends Annotation,T> extends Policy<A> {
    /**
     * Returns result of conversion of form field.  This is not called if the form value is empty string or null, unless
     * {@link #getProcessNoValue} returns true..
     */
    public ConversionResult<T> convert(String formValue, Class<?> recipientFieldClass, Class<? extends T> recipientClass) throws Exception;

    /**
     * Returns collection-based field value formatted for display in a form field.  Not called if the unformatted value 
     * is null or empty collection, unless {@link #getProcessNoValue} returns true.    
     */
    public String format(Collection<T> unformattedValues) throws Exception;
    
    /**
     * Returns whether to write any error message to action errors, field errors, or action messages. 
     */
    public MessageType getMessageType();
    
    /**
     * Returns message set by annotation.  Used if {@link #getMessageKey} is empty string or it fails to find a message. 
     */
    public String getMessage();
    
    /**
     * Returns message key set by annotation, which is used to retrieve message from Action's TextProvider if it's not 
     * empty string. 
     */
    public String getMessageKey();
    
    /**
     * Returns item types of recipient collection fields that can receive converted form value.  Not to be confused with 
     * collection type. 
     */
    public Class<T> getRecipientClass();
    
    /**
     * Returns name of field to receive converted form value, which can be empty string to use default. 
     */
    public String getRecipientFieldName();
    
    /**
     * Returns whether {@link #convert #convert} converts empty string value, and {@link #format #format} formats null value or empty 
     * collection. 
     */
    public boolean getProcessNoValue();
}
