package name.matthewgreet.strutscommons.form;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Value Object describing formatted field values to be placed on the Value Stack. 
 */
public class FormatResult implements Serializable {
	private static final long serialVersionUID = 2021732767012963984L;
	
	private Map<String,String> formattedSingleFieldValues = new HashMap<>();
	
	private Map<String,List<String>> formattedMultipleFieldValues = new HashMap<>();
	
	
	public Map<String, String> getFormattedSingleFieldValues() {
		return formattedSingleFieldValues;
	}

	public Map<String, List<String>> getFormattedMultipleFieldValues() {
		return formattedMultipleFieldValues;
	}

}
