package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * <P>Defines error message to display if any entry of an integer collection is null.</P>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Message Types</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>ERROR</TD>
 *     <TD>Message added to Action level error messages.  Default.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>FIELD</TD>
 *     <TD>Message added to field error messages using same name as field.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>MESSAGE</TD>
 *     <TD>Message added to Action level info messages.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>WARNING</TD>
 *     <TD>Message added to Action level warning messages.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Other Parameters</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>message</TD>
 *     <TD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is not set or finds no 
 *         message.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>messageKey</TD>
 *     <TD>If not empty string, message key to retrieve from Action's TextProvider.  Uses <CODE>message</CODE> if no key 
 *         provided or no message found.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>shortCircuit</TD>
 *     <TD>If true and this validation fails, skips further validation.  Defaults to false.</TD>
 *   </TR>
 * </TABLE>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequiredIntegerEntries {
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public boolean shortCircuit() default false;
}
