package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

/**
 * <P>Defines a form field (whether on a Struts Action or model of ModelDriven Struts Action) should be parsed to 
 * a int or Integer type and error message to display if this fails.  Also, defines a view helper field receives a 
 * formatted integer value.  This is the default converter for int and Integer fields.</P>
 *
 * <P>There are two modes of behaviour for conversion, depending on the type of form field.</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Validation Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Form field type</TH>
 *     <TH>Mode</TH>
 *     <TH>Description</TH>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String</TD>
 *     <TD>Pair conversion</TD>
 *     <TD>Converts string field value to int or Integer field named by parsedFieldName</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>int or Integer</TD>
 *     <TD>Auto conversion</TD>
 *     <TD>Converts directly from request parameter</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Message Types</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>ERROR</TD>
 *     <TD>Message added to Action level error messages.  Default.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>FIELD</TD>
 *     <TD>Message added to field error messages using same name as field.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>MESSAGE</TD>
 *     <TD>Message added to Action level info messages.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>WARNING</TD>
 *     <TD>Message added to Action level warning messages.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>Other parameters</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Other Parameters</CAPTION>
 *   <TR CLASS="row_odd">
 *     <TD>message</TD>
 *     <TD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is empty string or finds no 
 *         message.</TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>messageKey</TD>
 *     <TD>If not empty string, message key to retrieve from Action's TextProvider.  Uses <CODE>message</CODE> if no key 
 *         provided or no message found.</TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>parsedFieldName</TD>
 *     <TD>If not empty string, name of field to contain parsed value.  Defaults to 'parsed' plus capitalised field 
 *         name, such as 'parsedLimit'.  Only applies for pair conversion.</TD>
 *   </TR>
 * </TABLE>
 * 
 * <P>When applied to a view helper field, {@link StrutsMiscellaneousLibrary#updateDisplay StrutsMiscellaneousLibrary#updateDisplay} 
 *    formats from a source record field with the same name but only certain combinations are recognised.</P>
 * <TABLE CLASS="main">
 *   <CAPTION>Formatting Annotation Usage</CAPTION>
 *   <TR>
 *     <TH>Display field type</TH>
 *     <TH>Record field type</TH>
 *     <TH>Notes</TH>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String</TD>
 *     <TD>int or Integer</TD>
 *     <TD></TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>String array</TD>
 *     <TD>int or Integer array</TD>
 *     <TD></TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String array</TD>
 *     <TD>int or Integer collection</TD>
 *     <TD></TD>
 *   </TR>
 *   <TR CLASS="row_even">
 *     <TD>String collection</TD>
 *     <TD>int or Integer array</TD>
 *     <TD></TD>
 *   </TR>
 *   <TR CLASS="row_odd">
 *     <TD>String collection</TD>
 *     <TD>int or Integer collection</TD>
 *     <TD></TD>
 *   </TR>
 * </TABLE>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface IntegerConversion {
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public String parsedFieldName() default "";
}
