package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.policy.ShortConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class ShortConverterUnitTests {
	@ShortConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		ShortConversion annotation;
		ShortConverter shortConverter;
		ConversionResult<Short> result;
		
		annotation = (ShortConversion)ShortConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ShortConversion.class);
		shortConverter = new ShortConverter();
		shortConverter.setAnnotation(annotation);
		result = shortConverter.convert("64", Short.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(new Short("64"), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		ShortConversion annotation;
		ShortConverter shortConverter;
		ConversionResult<Short> result;
		
		annotation = (ShortConversion)ShortConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ShortConversion.class);
		shortConverter = new ShortConverter();
		shortConverter.setAnnotation(annotation);
		result = shortConverter.convert("$64", Short.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws NoSuchFieldException, SecurityException {
		ShortConversion annotation;
		ShortConverter shortConverter;
		String result;
		
		annotation = (ShortConversion)ShortConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ShortConversion.class);
		shortConverter = new ShortConverter();
		shortConverter.setAnnotation(annotation);
		result = shortConverter.format(new Short("-75"));
		Assertions.assertEquals("-75", result, "Final value is incorrect");
	}
    
}
