package name.matthewgreet.strutscommons.junit.policy;

import java.util.ArrayList;
import java.util.Collection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.RequiredIntegerEntries;
import name.matthewgreet.strutscommons.policy.RequiredIntegerEntriesValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;


public class RequiredIntegerEntriesValidatorUnitTests {
	@RequiredIntegerEntries
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Validation success")
	@Test
	public void testValidate1() throws Exception {
		RequiredIntegerEntries annotation;
		RequiredIntegerEntriesValidator requiredIntegerEntriesValidator;
		ValidationResult result;
		Collection<Integer> formValues;
		
		formValues = new ArrayList<>();
		formValues.add(999);
		formValues.add(-5587);
		formValues.add(0);
		
		annotation = (RequiredIntegerEntries)RequiredIntegerEntriesValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(RequiredIntegerEntries.class);
		requiredIntegerEntriesValidator = new RequiredIntegerEntriesValidator();
		requiredIntegerEntriesValidator.setAnnotation(annotation);
		result = requiredIntegerEntriesValidator.validate(formValues);
		Assertions.assertNotNull(result, "Validators never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Validation should be successful");
	}
    
	@DisplayName("Validation failure")
	@Test
	public void testValidate2() throws Exception {
		RequiredIntegerEntries annotation;
		RequiredIntegerEntriesValidator requiredIntegerEntriesValidator;
		ValidationResult result;
		Collection<Integer> formValues;
		
		formValues = new ArrayList<>();
		formValues.add(999);
		formValues.add(null);
		formValues.add(-5587);
		formValues.add(0);
		
		annotation = (RequiredIntegerEntries)RequiredIntegerEntriesValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(RequiredIntegerEntries.class);
		requiredIntegerEntriesValidator = new RequiredIntegerEntriesValidator();
		requiredIntegerEntriesValidator.setAnnotation(annotation);
		result = requiredIntegerEntriesValidator.validate(formValues);
		Assertions.assertNotNull(result, "Validators never return null");
		Assertions.assertEquals(false, result.getSuccess(), "Validation should be failure");
	}
    
	@DisplayName("Only null value")
	@Test
	public void testValidate3() throws Exception {
		RequiredIntegerEntries annotation;
		RequiredIntegerEntriesValidator requiredIntegerEntriesValidator;
		ValidationResult result;
		Collection<Integer> formValues;
		
		formValues = new ArrayList<>();
		formValues.add(null);
		
		annotation = (RequiredIntegerEntries)RequiredIntegerEntriesValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(RequiredIntegerEntries.class);
		requiredIntegerEntriesValidator = new RequiredIntegerEntriesValidator();
		requiredIntegerEntriesValidator.setAnnotation(annotation);
		result = requiredIntegerEntriesValidator.validate(formValues);
		Assertions.assertNotNull(result, "Validators never return null");
		Assertions.assertEquals(false, result.getSuccess(), "Validation should be failure");
	}
    
	@DisplayName("Empty collection")
	@Test
	public void testValidate4() throws Exception {
		RequiredIntegerEntries annotation;
		RequiredIntegerEntriesValidator requiredIntegerEntriesValidator;
		ValidationResult result;
		Collection<Integer> formValues;
		
		formValues = new ArrayList<>();
		
		annotation = (RequiredIntegerEntries)RequiredIntegerEntriesValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(RequiredIntegerEntries.class);
		requiredIntegerEntriesValidator = new RequiredIntegerEntriesValidator();
		requiredIntegerEntriesValidator.setAnnotation(annotation);
		result = requiredIntegerEntriesValidator.validate(formValues);
		Assertions.assertNotNull(result, "Validators never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Validation should be success");
	}
    
}
