package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.MinInteger;
import name.matthewgreet.strutscommons.policy.MinIntegerValidator;
import name.matthewgreet.strutscommons.policy.ValidationResult;


public class MinIntegerValidatorUnitTests {
	@MinInteger(min = 1)
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Validation success")
	@Test
	public void testValidate1() throws Exception {
		MinInteger annotation;
		MinIntegerValidator minIntegerValidator;
		ValidationResult result;
		
		annotation = (MinInteger)MinIntegerValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MinInteger.class);
		minIntegerValidator = new MinIntegerValidator();
		minIntegerValidator.setAnnotation(annotation);
		result = minIntegerValidator.validate(4);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Lower boundary")
	@Test
	public void testValidate2() throws Exception {
		MinInteger annotation;
		MinIntegerValidator minIntegerValidator;
		ValidationResult result;
		
		annotation = (MinInteger)MinIntegerValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MinInteger.class);
		minIntegerValidator = new MinIntegerValidator();
		minIntegerValidator.setAnnotation(annotation);
		result = minIntegerValidator.validate(1);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Validation failure")
	@Test
	public void testValidate3() throws Exception {
		MinInteger annotation;
		MinIntegerValidator minIntegerValidator;
		ValidationResult result;
		
		annotation = (MinInteger)MinIntegerValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MinInteger.class);
		minIntegerValidator = new MinIntegerValidator();
		minIntegerValidator.setAnnotation(annotation);
		result = minIntegerValidator.validate(-5);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Just outside lower boundary")
	@Test
	public void testValidate4() throws Exception {
		MinInteger annotation;
		MinIntegerValidator minIntegerValidator;
		ValidationResult result;
		
		annotation = (MinInteger)MinIntegerValidatorUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(MinInteger.class);
		minIntegerValidator = new MinIntegerValidator();
		minIntegerValidator.setAnnotation(annotation);
		result = minIntegerValidator.validate(0);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
}
