package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.policy.LongConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class LongConverterUnitTests {
	@LongConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		LongConversion annotation;
		LongConverter longConverter;
		ConversionResult<Long> result;
		
		annotation = (LongConversion)LongConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(LongConversion.class);
		longConverter = new LongConverter();
		longConverter.setAnnotation(annotation);
		result = longConverter.convert("334579", Long.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(new Long("334579"), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		LongConversion annotation;
		LongConverter longConverter;
		ConversionResult<Long> result;
		
		annotation = (LongConversion)LongConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(LongConversion.class);
		longConverter = new LongConverter();
		longConverter.setAnnotation(annotation);
		result = longConverter.convert("$334579", Long.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		LongConversion annotation;
		LongConverter longConverter;
		String result;
		
		annotation = (LongConversion)LongConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(LongConversion.class);
		longConverter = new LongConverter();
		longConverter.setAnnotation(annotation);
		result = longConverter.format(new Long("560009"));
		Assertions.assertEquals("560009", result, "Final value is incorrect");
	}
    
}
