package name.matthewgreet.strutscommons.junit.policy;

import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.policy.ConversionResult;
import name.matthewgreet.strutscommons.policy.FloatConverter;


public class FloatConverterUnitTests {
	@FloatConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		FloatConversion annotation;
		FloatConverter floatConverter;
		ConversionResult<Float> result;
		
		annotation = (FloatConversion)FloatConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(FloatConversion.class);
		floatConverter = new FloatConverter();
		floatConverter.setAnnotation(annotation);
		result = floatConverter.convert("4457.339", Float.class);
		Assert.assertNotNull("Converters never return null", result);
		Assert.assertEquals("Final value is incorrect", new Float("4457.339"), result.getParsedValue());
		Assert.assertEquals("Conversion should be successful", true, result.getSuccess());
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		FloatConversion annotation;
		FloatConverter floatConverter;
		ConversionResult<Float> result;
		
		annotation = (FloatConversion)FloatConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(FloatConversion.class);
		floatConverter = new FloatConverter();
		floatConverter.setAnnotation(annotation);
		result = floatConverter.convert("$4457.339", Float.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		FloatConversion annotation;
		FloatConverter floatConverter;
		String result;
		
		annotation = (FloatConversion)FloatConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(FloatConversion.class);
		floatConverter = new FloatConverter();
		floatConverter.setAnnotation(annotation);
		result = floatConverter.format(new Float("-75.445"));
		Assertions.assertEquals("-75.445", result, "Final value is incorrect");
	}
    
}
