package name.matthewgreet.strutscommons.junit.library;

import java.util.HashMap;

import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import com.opensymphony.xwork2.ActionContext;

import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.BasicDisplay;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.BasicForm;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.BasicSourceDTO;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.CountryDisplay;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.CountryMismatchDisplay;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.CountrySourceDTO;
import name.matthewgreet.strutscommons.junit.strutsmiscellaneouslibrary.NoAnnotationForm;
import name.matthewgreet.strutscommons.util.StrutsMiscellaneousLibrary;

@SuppressWarnings("deprecation")
public class StrutsMiscellaneousLibraryUnitTests {
	@BeforeEach
	public void init() {
		ActionContext.bind(ActionContext.of(new HashMap<>()));
	}
	
	
	@DisplayName("Formats correct form")
	@Test
	public void testFormatForm1() {
		BasicForm form;
		
		form = new BasicForm();
		StrutsMiscellaneousLibrary.formatForm(form);
		Assert.assertEquals("Non null BigDecimal failed", "12.9", form.getBigDecimalNonNull());
		Assert.assertEquals("Null BigDecimal failed", "", form.getBigDecimalNull());
		Assert.assertEquals("Primitive boolean failed", "1", form.getPrimitiveBooleanField());
		Assert.assertEquals("Non null boolean failed", "1", form.getObjectBooleanFieldNonNull());
		Assert.assertEquals("Null Boolean failed", "", form.getObjectBooleanFieldNull());
		Assert.assertEquals("Primitive byte failed", "63", form.getPrimitiveByteField());
		Assert.assertEquals("Non null Byte failed", "63", form.getObjectByteFieldNonNull());
		Assert.assertEquals("Null Byte failed", "", form.getObjectByteFieldNull());
		Assert.assertEquals("Primitive char failed", "^", form.getPrimitiveCharField());
		Assert.assertEquals("Non null Character failed", "^", form.getObjectCharacterFieldNonNull());
		Assert.assertEquals("Null Character failed", "", form.getObjectCharacterFieldNull());
		Assert.assertEquals("Non null Date failed", "13/12/2020", form.getDateFieldNonNull());
		Assert.assertEquals("Null Date failed", "", form.getDateFieldNull());
		Assert.assertEquals("Primitive double failed", "-7235258.45", form.getPrimitiveDoubleField());
		Assert.assertEquals("Non null Double failed", "-7235258.45", form.getObjectDoubleFieldNonNull());
		Assert.assertEquals("Null Double failed", "", form.getObjectDoubleFieldNull());
		Assert.assertEquals("Non null Enum failed", "RED", form.getEnumFieldNonNull());
		Assert.assertEquals("Null Enum failed", "", form.getEnumFieldNull());
		Assert.assertEquals("Primitive float failed", "-345.45", form.getPrimitiveFloatField());
		Assert.assertEquals("Non null Float failed", "-345.45", form.getObjectFloatFieldNonNull());
		Assert.assertEquals("Null Float failed", "", form.getObjectFloatFieldNull());
		Assert.assertEquals("Primitive int failed", "23", form.getPrimitiveIntField());
		Assert.assertEquals("Non null Integer failed", "23", form.getObjectIntegerFieldNonNull());
		Assert.assertEquals("Null Integer failed", "", form.getObjectIntegerFieldNull());
		Assert.assertEquals("Primitive long failed", "367674", form.getPrimitiveLongField());
		Assert.assertEquals("Non null Long failed", "367674", form.getObjectLongFieldNonNull());
		Assert.assertEquals("Null Long failed", "", form.getObjectLongFieldNull());
		Assert.assertEquals("Primitive short failed", "34", form.getPrimitiveShortField());
		Assert.assertEquals("Non null Short failed", "34", form.getObjectShortFieldNonNull());
		Assert.assertEquals("Null Short failed", "", form.getObjectShortFieldNull());
	}
	
	@DisplayName("Ignores form without annotations")
	@Test
	public void testFormatForm2() {
		NoAnnotationForm form;
		
		form = new NoAnnotationForm();
		StrutsMiscellaneousLibrary.formatForm(form);
		Assert.assertEquals("Non null BigDecimal failed", "12.9", form.getBigDecimalNonNull());
		Assert.assertEquals("Null BigDecimal failed", "", form.getBigDecimalNull());
		Assert.assertEquals("Primitive boolean failed", "1", form.getPrimitiveBooleanField());
		Assert.assertEquals("Non null boolean failed", "1", form.getObjectBooleanFieldNonNull());
		Assert.assertEquals("Null Boolean failed", "", form.getObjectBooleanFieldNull());
		Assert.assertEquals("Primitive byte failed", "63", form.getPrimitiveByteField());
		Assert.assertEquals("Non null Byte failed", "63", form.getObjectByteFieldNonNull());
		Assert.assertEquals("Null Byte failed", "", form.getObjectByteFieldNull());
		Assert.assertEquals("Primitive char failed", "^", form.getPrimitiveCharField());
		Assert.assertEquals("Non null Character failed", "^", form.getObjectCharacterFieldNonNull());
		Assert.assertEquals("Null Character failed", "", form.getObjectCharacterFieldNull());
		Assert.assertEquals("Non null Date failed", "13/12/2020", form.getDateFieldNonNull());
		Assert.assertEquals("Null Date failed", "", form.getDateFieldNull());
		Assert.assertEquals("Primitive double failed", "-7235258.45", form.getPrimitiveDoubleField());
		Assert.assertEquals("Non null Double failed", "-7235258.45", form.getObjectDoubleFieldNonNull());
		Assert.assertEquals("Null Double failed", "", form.getObjectDoubleFieldNull());
		Assert.assertEquals("Non null Enum failed", "RED", form.getEnumFieldNonNull());
		Assert.assertEquals("Null Enum failed", "", form.getEnumFieldNull());
		Assert.assertEquals("Primitive float failed", "-345.45", form.getPrimitiveFloatField());
		Assert.assertEquals("Non null Float failed", "-345.45", form.getObjectFloatFieldNonNull());
		Assert.assertEquals("Null Float failed", "", form.getObjectFloatFieldNull());
		Assert.assertEquals("Primitive int failed", "23", form.getPrimitiveIntField());
		Assert.assertEquals("Non null Integer failed", "23", form.getObjectIntegerFieldNonNull());
		Assert.assertEquals("Null Integer failed", "", form.getObjectIntegerFieldNull());
		Assert.assertEquals("Primitive long failed", "367674", form.getPrimitiveLongField());
		Assert.assertEquals("Non null Long failed", "367674", form.getObjectLongFieldNonNull());
		Assert.assertEquals("Null Long failed", "", form.getObjectLongFieldNull());
		Assert.assertEquals("Primitive short failed", "34", form.getPrimitiveShortField());
		Assert.assertEquals("Non null Short failed", "34", form.getObjectShortFieldNonNull());
		Assert.assertEquals("Null Short failed", "", form.getObjectShortFieldNull());
	}
	
	@DisplayName("Copies and formats matching fields")
	@Test
	public void testUpdateDisplay1() {
		BasicDisplay display;
		
		display = new BasicDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(BasicSourceDTO.class, new BasicSourceDTO(), display);
		Assert.assertEquals("Non null BigDecimal failed", "12.9", display.getBigDecimalNonNull());
		Assert.assertEquals("Null BigDecimal failed", "", display.getBigDecimalNull());
		Assert.assertEquals("Primitive boolean failed", "1", display.getPrimitiveBooleanField());
		Assert.assertEquals("Non null boolean failed", "1", display.getObjectBooleanFieldNonNull());
		Assert.assertEquals("Null Boolean failed", "", display.getObjectBooleanFieldNull());
		Assert.assertEquals("Primitive byte failed", "63", display.getPrimitiveByteField());
		Assert.assertEquals("Non null Byte failed", "63", display.getObjectByteFieldNonNull());
		Assert.assertEquals("Null Byte failed", "", display.getObjectByteFieldNull());
		Assert.assertEquals("Primitive char failed", "^", display.getPrimitiveCharField());
		Assert.assertEquals("Non null Character failed", "^", display.getObjectCharacterFieldNonNull());
		Assert.assertEquals("Null Character failed", "", display.getObjectCharacterFieldNull());
		Assert.assertEquals("Non null Date failed", "13/12/2020", display.getDateFieldNonNull());
		Assert.assertEquals("Null Date failed", "", display.getDateFieldNull());
		Assert.assertEquals("Primitive double failed", "-7235258.45", display.getPrimitiveDoubleField());
		Assert.assertEquals("Non null Double failed", "-7235258.45", display.getObjectDoubleFieldNonNull());
		Assert.assertEquals("Null Double failed", "", display.getObjectDoubleFieldNull());
		Assert.assertEquals("Non null Enum failed", "RED", display.getEnumFieldNonNull());
		Assert.assertEquals("Null Enum failed", "", display.getEnumFieldNull());
		Assert.assertEquals("Primitive float failed", "-345.45", display.getPrimitiveFloatField());
		Assert.assertEquals("Non null Float failed", "-345.45", display.getObjectFloatFieldNonNull());
		Assert.assertEquals("Null Float failed", "", display.getObjectFloatFieldNull());
		Assert.assertEquals("Primitive int failed", "23", display.getPrimitiveIntField());
		Assert.assertEquals("Non null Integer failed", "23", display.getObjectIntegerFieldNonNull());
		Assert.assertEquals("Null Integer failed", "", display.getObjectIntegerFieldNull());
		Assert.assertEquals("Primitive long failed", "367674", display.getPrimitiveLongField());
		Assert.assertEquals("Non null Long failed", "367674", display.getObjectLongFieldNonNull());
		Assert.assertEquals("Null Long failed", "", display.getObjectLongFieldNull());
		Assert.assertEquals("Primitive short failed", "34", display.getPrimitiveShortField());
		Assert.assertEquals("Non null Short failed", "34", display.getObjectShortFieldNonNull());
		Assert.assertEquals("Null Short failed", "", display.getObjectShortFieldNull());
		Assert.assertEquals("Non null String failed", "To boldly go where no man has gone before!", display.getStringFieldNonNull());
		Assert.assertEquals("Null String failed", "", display.getStringFieldNull());
		// Not formatted
		Assert.assertArrayEquals("String array failed", null, display.getStringArray());
		Assert.assertEquals("String collection failed", null, display.getStringCollection());
		Assert.assertArrayEquals("int array failed", null, display.getIntArray());
		Assert.assertEquals("Integer collection failed", null, display.getIntCollection());
	}
    
	@DisplayName("Null source")
	@Test
	public void testUpdateDisplay2() {
		BasicDisplay display;
		
		display = new BasicDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(BasicSourceDTO.class, null, display);
		Assert.assertEquals("Non null BigDecimal failed", "", display.getBigDecimalNonNull());
		Assert.assertEquals("Null BigDecimal failed", "", display.getBigDecimalNull());
		Assert.assertEquals("Primitive boolean failed", "", display.getPrimitiveBooleanField());
		Assert.assertEquals("Non null boolean failed", "", display.getObjectBooleanFieldNonNull());
		Assert.assertEquals("Null Boolean failed", "", display.getObjectBooleanFieldNull());
		Assert.assertEquals("Primitive byte failed", "", display.getPrimitiveByteField());
		Assert.assertEquals("Non null Byte failed", "", display.getObjectByteFieldNonNull());
		Assert.assertEquals("Null Byte failed", "", display.getObjectByteFieldNull());
		Assert.assertEquals("Primitive char failed", "", display.getPrimitiveCharField());
		Assert.assertEquals("Non null Character failed", "", display.getObjectCharacterFieldNonNull());
		Assert.assertEquals("Null Character failed", "", display.getObjectCharacterFieldNull());
		Assert.assertEquals("Non null Date failed", "", display.getDateFieldNonNull());
		Assert.assertEquals("Null Date failed", "", display.getDateFieldNull());
		Assert.assertEquals("Primitive double failed", "", display.getPrimitiveDoubleField());
		Assert.assertEquals("Non null Double failed", "", display.getObjectDoubleFieldNonNull());
		Assert.assertEquals("Null Double failed", "", display.getObjectDoubleFieldNull());
		Assert.assertEquals("Non null Enum failed", "", display.getEnumFieldNonNull());
		Assert.assertEquals("Null Enum failed", "", display.getEnumFieldNull());
		Assert.assertEquals("Primitive float failed", "", display.getPrimitiveFloatField());
		Assert.assertEquals("Non null Float failed", "", display.getObjectFloatFieldNonNull());
		Assert.assertEquals("Null Float failed", "", display.getObjectFloatFieldNull());
		Assert.assertEquals("Primitive int failed", "", display.getPrimitiveIntField());
		Assert.assertEquals("Non null Integer failed", "", display.getObjectIntegerFieldNonNull());
		Assert.assertEquals("Null Integer failed", "", display.getObjectIntegerFieldNull());
		Assert.assertEquals("Primitive long failed", "", display.getPrimitiveLongField());
		Assert.assertEquals("Non null Long failed", "", display.getObjectLongFieldNonNull());
		Assert.assertEquals("Null Long failed", "", display.getObjectLongFieldNull());
		Assert.assertEquals("Primitive short failed", "", display.getPrimitiveShortField());
		Assert.assertEquals("Non null Short failed", "", display.getObjectShortFieldNonNull());
		Assert.assertEquals("Null Short failed", "", display.getObjectShortFieldNull());
		Assert.assertEquals("Non null String failed", "", display.getStringFieldNonNull());
		Assert.assertEquals("Null String failed", "", display.getStringFieldNull());
		// Not formatted
		Assert.assertArrayEquals("String array failed", null, display.getStringArray());
		Assert.assertEquals("String collection failed", null, display.getStringCollection());
		Assert.assertArrayEquals("int array failed", null, display.getIntArray());
		Assert.assertEquals("Integer collection failed", null, display.getIntCollection());
	}
    
	@DisplayName("Source fields not found in display, existing source")
	@Test
	public void testUpdateDisplay3() {
		CountryDisplay display;
		
		display = new CountryDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(CountrySourceDTO.class, new CountrySourceDTO(), display);
		Assert.assertEquals("Id failed", "67", display.getId());
		Assert.assertEquals("Name failed", "Australia", display.getName());
		Assert.assertEquals("ShortCode failed", "AU", display.getShortCode());
	}
    
	@DisplayName("Source fields not found in display, null source")
	@Test
	public void testUpdateDisplay4() {
		CountryDisplay display;
		
		display = new CountryDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(CountrySourceDTO.class, null, display);
		Assert.assertEquals("Id failed", "", display.getId());
		Assert.assertEquals("Name failed", "", display.getName());
		Assert.assertEquals("ShortCode failed", "", display.getShortCode());
	}
    
	@DisplayName("Source fields set non-string in display, existing source")
	@Test
	public void testUpdateDisplay5() {
		CountryMismatchDisplay display;
		
		display = new CountryMismatchDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(CountrySourceDTO.class, new CountrySourceDTO(), display);
		Assert.assertEquals("Id failed", 0, display.getId());
		Assert.assertEquals("Name failed", "Australia", display.getName());
		Assert.assertEquals("ShortCode failed", "AU", display.getShortCode());
	}
    
	@DisplayName("Source fields set non-string in display, null source")
	@Test
	public void testUpdateDisplay6() {
		CountryMismatchDisplay display;
		
		display = new CountryMismatchDisplay();
		StrutsMiscellaneousLibrary.updateDisplay(CountrySourceDTO.class, null, display);
		Assert.assertEquals("Id failed", 0, display.getId());
		Assert.assertEquals("Name failed", "", display.getName());
		Assert.assertEquals("ShortCode failed", "", display.getShortCode());
	}
    
}
