package name.matthewgreet.strutscommons.junit.defaultannotationvalidator;

import java.math.BigDecimal;
import java.util.Date;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.annotation.BooleanConversion;
import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.annotation.CustomConversion;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.DoubleConversion;
import name.matthewgreet.strutscommons.annotation.EnumConversion;
import name.matthewgreet.strutscommons.annotation.FloatConversion;
import name.matthewgreet.strutscommons.annotation.IntegerConversion;
import name.matthewgreet.strutscommons.annotation.LongConversion;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.form.AbstractForm;
import name.matthewgreet.strutscommons.junit.defaultformformatter.GBPConverter;

@SuppressWarnings("deprecation")
public class PairConversionForm extends AbstractForm {
	private static final long serialVersionUID = 6563502000492088949L;
	
	public enum Colour {RED, GREEN, BLUE}
	
	@BigDecimalConversion(message = "Big decimal conversion failed")
	private String bigDecimalField;
	private BigDecimal parsedBigDecimalField;
	@BooleanConversion
	private String primitiveBooleanField;
	private boolean parsedPrimitiveBooleanField;
	@BooleanConversion
	private String objectBooleanField;
	private Boolean parsedObjectBooleanField;
	@ByteConversion(message = "Byte conversion failed")
	private String primitiveByteField;
	private byte parsedPrimitiveByteField;
	@ByteConversion(message = "Byte conversion failed")
	private String objectByteField;
	private Byte parsedObjectByteField;
	@CharacterConversion
	private String primitiveCharField;
	private char parsedPrimitiveCharField;
	@CharacterConversion
	private String objectCharacterField;
	private Character parsedObjectCharacterField;
	@DateConversion(message = "Date conversion failed")
	private String dateField;
	private Date parsedDateField;
	@DoubleConversion(message = "Double conversion failed")
	private String primitiveDoubleField;
	private double parsedPrimitiveDoubleField;
	@DoubleConversion(message = "Double conversion failed")
	private String objectDoubleField;
	private Double parsedObjectDoubleField;
	@EnumConversion(message = "Enum conversion failed")
	private String enumField;
	private Colour parsedEnumField;
	@FloatConversion(message = "Float conversion failed")
	private String primitiveFloatField;
	private float parsedPrimitiveFloatField;
	@FloatConversion(message = "Float conversion failed")
	private String objectFloatField;
	private Float parsedObjectFloatField;
	@IntegerConversion(message = "Integer conversion failed")
	private String primitiveIntField;
	private int parsedPrimitiveIntField;
	@IntegerConversion(message = "Integer conversion failed")
	private String objectIntegerField;
	private Integer parsedObjectIntegerField;
	@LongConversion(message = "Long conversion failed")
	private String primitiveLongField;
	private long parsedPrimitiveLongField;
	@LongConversion(message = "Long conversion failed")
	private String objectLongField;
	private Long parsedObjectLongField;
	@ShortConversion(message = "Short conversion failed")
	private String primitiveShortField;
	private short parsedPrimitiveShortField;
	@ShortConversion(message = "Short conversion failed")
	private String objectShortField;
	private Short parsedObjectShortField;
	@CustomConversion(validatorClass = GBPConverter.class)
	private String customField;
	private int parsedCustomField;
	
	
	@Override
	public void resetFields() {
		// Nothing
	}
	
	@Override
	public void doValidate(ValidationAware validationAware, TextProvider textProvider) {
		// Nothing
	}

	public String getBigDecimalField() {
		return bigDecimalField;
	}
	public void setBigDecimalField(String bigDecimalField) {
		this.bigDecimalField = bigDecimalField;
	}

	public BigDecimal getParsedBigDecimalField() {
		return parsedBigDecimalField;
	}
	public void setParsedBigDecimalField(BigDecimal parsedBigDecimalField) {
		this.parsedBigDecimalField = parsedBigDecimalField;
	}

	public String getPrimitiveBooleanField() {
		return primitiveBooleanField;
	}
	public void setPrimitiveBooleanField(String primitiveBooleanField) {
		this.primitiveBooleanField = primitiveBooleanField;
	}

	public String getObjectBooleanField() {
		return objectBooleanField;
	}
	public void setObjectBooleanField(String objectBooleanField) {
		this.objectBooleanField = objectBooleanField;
	}

	public String getPrimitiveByteField() {
		return primitiveByteField;
	}
	public void setPrimitiveByteField(String primitiveByteField) {
		this.primitiveByteField = primitiveByteField;
	}

	public String getObjectByteField() {
		return objectByteField;
	}
	public void setObjectByteField(String objectByteField) {
		this.objectByteField = objectByteField;
	}

	public String getPrimitiveCharField() {
		return primitiveCharField;
	}
	public void setPrimitiveCharField(String primitiveCharField) {
		this.primitiveCharField = primitiveCharField;
	}

	public String getObjectCharacterField() {
		return objectCharacterField;
	}
	public void setObjectCharacterField(String objectCharacterField) {
		this.objectCharacterField = objectCharacterField;
	}

	public String getDateField() {
		return dateField;
	}
	public void setDateField(String dateField) {
		this.dateField = dateField;
	}

	public String getPrimitiveDoubleField() {
		return primitiveDoubleField;
	}
	public void setPrimitiveDoubleField(String primitiveDoubleField) {
		this.primitiveDoubleField = primitiveDoubleField;
	}

	public String getObjectDoubleField() {
		return objectDoubleField;
	}
	public void setObjectDoubleField(String objectDoubleField) {
		this.objectDoubleField = objectDoubleField;
	}

	public String getEnumField() {
		return enumField;
	}
	public void setEnumField(String enumField) {
		this.enumField = enumField;
	}

	public String getPrimitiveFloatField() {
		return primitiveFloatField;
	}
	public void setPrimitiveFloatField(String primitiveFloatField) {
		this.primitiveFloatField = primitiveFloatField;
	}

	public String getObjectFloatField() {
		return objectFloatField;
	}
	public void setObjectFloatField(String objectFloatField) {
		this.objectFloatField = objectFloatField;
	}

	public String getPrimitiveIntField() {
		return primitiveIntField;
	}
	public void setPrimitiveIntField(String primitiveIntField) {
		this.primitiveIntField = primitiveIntField;
	}

	public String getObjectIntegerField() {
		return objectIntegerField;
	}
	public void setObjectIntegerField(String objectIntegerField) {
		this.objectIntegerField = objectIntegerField;
	}

	public String getPrimitiveLongField() {
		return primitiveLongField;
	}
	public void setPrimitiveLongField(String primitiveLongField) {
		this.primitiveLongField = primitiveLongField;
	}

	public String getObjectLongField() {
		return objectLongField;
	}
	public void setObjectLongField(String objectLongField) {
		this.objectLongField = objectLongField;
	}

	public String getPrimitiveShortField() {
		return primitiveShortField;
	}
	public void setPrimitiveShortField(String primitiveShortField) {
		this.primitiveShortField = primitiveShortField;
	}

	public String getObjectShortField() {
		return objectShortField;
	}
	public void setObjectShortField(String objectShortField) {
		this.objectShortField = objectShortField;
	}

	public String getCustomField() {
		return customField;
	}
	public void setCustomField(String customField) {
		this.customField = customField;
	}

	public boolean getParsedPrimitiveBooleanField() {
		return parsedPrimitiveBooleanField;
	}
	public Boolean getParsedObjectBooleanField() {
		return parsedObjectBooleanField;
	}
	public byte getParsedPrimitiveByteField() {
		return parsedPrimitiveByteField;
	}
	public Byte getParsedObjectByteField() {
		return parsedObjectByteField;
	}
	public char getParsedPrimitiveCharField() {
		return parsedPrimitiveCharField;
	}
	public Character getParsedObjectCharacterField() {
		return parsedObjectCharacterField;
	}
	public Date getParsedDateField() {
		return parsedDateField;
	}
	public double getParsedPrimitiveDoubleField() {
		return parsedPrimitiveDoubleField;
	}
	public Double getParsedObjectDoubleField() {
		return parsedObjectDoubleField;
	}
	public Colour getParsedEnumField() {
		return parsedEnumField;
	}
	public float getParsedPrimitiveFloatField() {
		return parsedPrimitiveFloatField;
	}
	public Float getParsedObjectFloatField() {
		return parsedObjectFloatField;
	}
	public int getParsedPrimitiveIntField() {
		return parsedPrimitiveIntField;
	}
	public Integer getParsedObjectIntegerField() {
		return parsedObjectIntegerField;
	}
	public long getParsedPrimitiveLongField() {
		return parsedPrimitiveLongField;
	}
	public Long getParsedObjectLongField() {
		return parsedObjectLongField;
	}
	public short getParsedPrimitiveShortField() {
		return parsedPrimitiveShortField;
	}
	public Short getParsedObjectShortField() {
		return parsedObjectShortField;
	}
	public Integer getParsedCustomField() {
		return parsedCustomField;
	}

}
