package name.matthewgreet.strutscommons.util;

import java.io.Serializable;

/**
 * Strategy for finding single item.
 */
@FunctionalInterface
public interface SingleItemFinder<K extends Serializable,T extends Serializable> extends Serializable {
    
    /**
     * Retrieves item from primary key or id, or null if not found.   
     */
    public T getItem(K key) throws Exception;
}
