package name.matthewgreet.strutscommons.util;

import java.io.Serializable;

import name.matthewgreet.strutscommons.util.ListCache.ListCacheConfig;



/**
 * <P>Template for web level, session-based caching a master, record list with one slave list for editing in various web 
 *    pages.  Subclasses of this, as well as defining the record types, typically set list finders and other Strategies 
 *    for record list relationships and pagination that clients don't set themselves, depending on web page workflow.  
 *    Instances are typically created as Singletons.</P>
 *    
 * <DL>
 * <DT>KM</DT><DD>Type primary key of master records</DD>
 * <DT>TM</DT><DD>Type of master records</DD>
 * <DT>K1</DT><DD>Type primary key of slave list 1 records</DD>
 * <DT>T1</DT><DD>Type of slave list 1 records</DD>
 * </DL>
 * 
 * <P>As there are a bewildering set of configuration options and client Struts actions are expected to know their 
 *    responsibilities in workflow, subclasses are a convenient Javadoc reference point for documenting this, such as 
 *    below.</P>
 * 
 * <TABLE>
 *   <CAPTION>Example Javadoc</CAPTION>
 *   <TR>
 *     <TH>Slave list no</TH>
 *     <TH>Name</TH>
 *     <TH>Description</TH>
 *     <TH>Viewer action</TH>
 *     <TH>Base record</TH>
 *     <TH>Other base record data</TH>
 *     <TH>Page extension data</TH>
 *     <TH>Detail data</TH>
 *     <TH>Pagination mode</TH>
 *     <TH>List/id/size finder</TH>
 *     <TH>Page finder/ page extension assembler</TH>
 *     <TH>Single item finder</TH>
 *   </TR>
 *   <TR>
 *     <TD>Master</TD>
 *     <TD>Board games</TD>
 *     <TD>Board games in Board Game Geek database up to 2022</TD>
 *     <TD><CODE>ViewGameListAction</CODE></TD>
 *     <TD><CODE>GameDTO</CODE></TD>
 *     <TD>&nbsp;</TD>
 *     <TD>Related designers</TD>
 *     <TD>Related artists, mechanics, and publishers</TD>
 *     <TD STYLE="text-align: center">Depends on search criteria</TD>
 *     <TD STYLE="text-align: center">Supplied by FindGameListByDesignerNameAction, FindGameListByFamileAction, FindGameListByNameContainsAction and FindGameListByRankAction</TD>
 *     <TD STYLE="text-align: center">GamePageByIdsFinder, GamePageExtensionAssembler</TD>
 *     <TD STYLE="text-align: center">GameItemFinder</TD>
 *   </TR>
 *   <TR>
 *     <TD>1</TD>
 *     <TD>Ratings distribution</TD>
 *     <TD>Counts of each user ratings of 0 to 10</TD>
 *     <TD><CODE>ViewRatingDistributionListAction</CODE></TD>
 *     <TD><CODE>GameRatingDTO</CODE></TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD STYLE="text-align: center">Full list</TD>
 *     <TD STYLE="text-align: center">GameRatingByGameIdListFinder</TD>
 *     <TD STYLE="text-align: center">N/A</TD>
 *     <TD STYLE="text-align: center">&nbsp;</TD>
 *   </TR>
 *   <TR>
 *     <TD>2</TD>
 *     <TD>User ratings</TD>
 *     <TD>Individual user ratings</TD>
 *     <TD><CODE>ViewUserRatingListAction</CODE></TD>
 *     <TD>UserRatingDTO</TD>
 *     <TD>&nbsp;</TD>
 *     <TD>Owning username</TD>
 *     <TD>&nbsp;</TD>
 *     <TD STYLE="text-align: center">Base record list</TD>
 *     <TD STYLE="text-align: center">Supplied by FindUserRatingListByUsernameContainsAction and FindUserRatingListByRatingAction</TD>
 *     <TD STYLE="text-align: center">UserRatingPageExtensionAssembler</TD>
 *     <TD STYLE="text-align: center">&nbsp;</TD>
 *   </TR>
 * </TABLE>
 */
@SuppressWarnings("javadoc")
public abstract class AbstractCompositeCache_1S<KM extends Serializable,TM extends Serializable,
                                                K1 extends Serializable,T1 extends Serializable> extends AbstractCompositeCache<KM,TM> {
    private static final long serialVersionUID = 1722427651490036480L;
    
    private ListCache<TM,K1,T1> slaveList1;

    /**
     * Creates session-based, composite cache with a master list and 1 slave list. 
     */
    protected AbstractCompositeCache_1S() {
        super();
        
        ListCacheConfig<TM,K1,T1> slaveListCacheConfig1 = getSlaveListCache1Config();
        slaveList1 = new ListCache<TM,K1,T1>(slaveListCacheConfig1, getMasterListCache());
        slaveList1.addListCacheListener(listCache -> {notifySlaveListCache1Changed(listCache);});
    }
    
    public AbstractCompositeCache_1S(AbstractCompositeCache_1S<KM,TM,K1,T1> abstractCompositeCache) throws Exception {
    	super(abstractCompositeCache);
    	slaveList1 = new ListCache<TM,K1,T1>(abstractCompositeCache.getSlaveListCache1(), getMasterListCache());
        slaveList1.addListCacheListener(listCache -> {notifySlaveListCache1Changed(listCache);});
    }
    

    /**
     * Overridden by concrete implementations to configure slave list cache 1. 
     */
    protected abstract ListCacheConfig<TM,K1,T1> getSlaveListCache1Config();
    
    
    /**
     * Notification that the slave list cache 1 has changed.
     */
    protected void notifySlaveListCache1Changed(ListCache<?,?,T1> listCache) {
        // Nothing but may be overridden.
    }

    /**
     * Returns cache of slave list 1. 
     */
    public ListCache<TM,K1,T1> getSlaveListCache1() {
        return slaveList1;
    }
    
}
