package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * Describes result of a validation.  Clients should use static methods starting with 'make'.
 */
public class ValidationResult {
	/**
	 * Returns result for validation pass. 
	 */
    public static ValidationResult makeSuccessResult() {
        ValidationResult result;
        
        result = new ValidationResult();
        result.setSuccess(true);
        return result;
    }
    
    /**
     * Returns result for validation fail and using annotation message configuration.  
     */
    public static ValidationResult makeFailureResult() {
        ValidationResult result;
        
        result = new ValidationResult();
        result.setSuccess(false);
        return new ValidationResult(false, null, null, null);
    }
    
    /**
     * Returns result for validation fail and using supplied message. 
     */
    public static ValidationResult makeFailureWithMessageResult(String message, MessageType messageType) {
        ValidationResult result;
        
        result = new ValidationResult();
        result.setSuccess(false);
        result.setMessage(message);
        result.setMessageType(messageType);
        return result;
    }

    /**
     * Returns result for validation fail and using supplied message key. 
     */
    public static ValidationResult makeFailureWithMessageKeyResult(String messageKey, MessageType messageType) {
        ValidationResult result;
        
        result = new ValidationResult();
        result.setSuccess(false);
        result.setMessageKey(messageKey);
        result.setMessageType(messageType);
        return result;
    }
    
    private boolean success;
    private String message;
    private String messageKey;
    private MessageType messageType;
    private boolean shortCircuit;
    
    public ValidationResult() {
        super();
        this.success = false;
        this.message = null;
        this.messageKey = null;
        this.messageType = null;
        this.shortCircuit = false;
    }
    
    public ValidationResult(boolean success, String message, String messageKey, MessageType messageType) {
        super();
        this.success = success;
        this.message = message;
        this.messageKey = messageKey;
        this.messageType = messageType;
        this.shortCircuit = false;
    }
    
    
    public boolean getSuccess() {
        return success;
    }
    public void setSuccess(boolean success) {
        this.success = success;
    }
    
    /**
     * If validation failed, returns error message to use (if messageKey not set), or null to use annotation setting. 
     */
    public String getMessage() {
        return message;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    
    /**
     * If validation failed, returns error message key to use, or null to use annotation setting. 
     */
    public String getMessageKey() {
        return messageKey;
    }
    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }
    
    /**
     * If validation failed, returns message list to use, or null to use annotation setting. 
     */
    public MessageType getMessageType() {
        return messageType;
    }
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    /**
     * If validation failed, returns whether to stop further validation of the same type. 
     */
	public boolean getShortCircuit() {
		return shortCircuit;
	}
	public void setShortCircuit(boolean shortCircuit) {
		this.shortCircuit = shortCircuit;
	}
    
}