package name.matthewgreet.strutscommons.policy;

import java.util.Collection;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.annotation.RequiredIntegerEntries;

public class RequiredIntegerEntriesValidator extends AbstractCollectionPostConversionValidatorSupport<RequiredIntegerEntries,Integer> {

	@Override
	public MessageType getMessageType() {
        return getAnnotation().messageType();
	}

	@Override
	public String getMessage() {
        return getAnnotation().message();
	}

	@Override
	public String getMessageKey() {
        return getAnnotation().messageKey();
	}

	@Override
	public Class<Integer> getRecipientClass() {
		return Integer.class;
	}

	@Override
	public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
	}

	@Override
	public boolean getProcessNoValue() {
		return false;
	}

	@Override
	public ValidationResult validate(Collection<Integer> formValue) throws Exception {
		for (Integer entry: formValue) {
			if (entry == null) {
	            return ValidationResult.makeFailureResult();
			}
		}
        return ValidationResult.makeSuccessResult();
	}

}
