package name.matthewgreet.strutscommons.exception;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * Exception describing that a converter or post-conversion validator (for single value or collection) is not compatible 
 * with a form field's type.
 */
public class FormFieldAnnotationTypeMismatchException extends Exception {
	private static final long serialVersionUID = 6870202888076321271L;

	private Annotation annotation;
	private Field formField;
	
	public FormFieldAnnotationTypeMismatchException(Annotation annotation, Field formField) {
		super("Annotation " + annotation.getClass() + " does not apply to fields of type " + formField.getType());
		this.annotation = annotation;
		this.formField = formField;
	}

	public Annotation getAnnotation() {
		return annotation;
	}
	public Field getFormField() {
		return formField;
	}
	
}
