package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <P>Defines a form field value (whether on a Struts Action or model of ModelDriven Struts Action) should be 
 * trimmed using the String.trim() function.  This is useful where users copy and paste values and inadvertently copy 
 * spaces.</P>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Trim {
    // Empty
}
