package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * <P>Defines error message to display if an integer is not within a range.</P>
 * 
 * <P>By default, messages are added to the actionErrors list but this can be overridden by <CODE>messageType</CODE>:</P>
 * <DL>
 *   <DT>ERROR</DT><DD>Message added to Action level error messages.  Default.</DD>
 *   <DT>FIELD</DT><DD>Message added to field error messages.</DD>
 *   <DT>MESSAGE</DT><DD>Message added to Action level info messages.</DD>
 * </DL>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>max</DT><DD>Maximum value (inclusive).  No default.</DD>
 *   <DT>min</DT><DD>Minimum value (inclusive).  No default.</DD>
 *   <DT>message</DT><DD>If not empty string, text message to display.  Used if <CODE>messageKey</CODE> is not set 
 *                       or finds no message.</DD>
 *   <DT>messageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider.  Uses 
 *                          <CODE>message</CODE> if no key provided or no message found.</DD>
 *   <DT>shortCircuit</DT><DD>If true and this validation fails, skips further validation.  Defaults to false.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface IntegerRange {
    public int max(); 
    public int min(); 
    public String message() default "";
    public String messageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public boolean shortCircuit() default false;
}
