package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.ToUpperCase;
import name.matthewgreet.strutscommons.policy.ToUpperCaseAdjuster;

public class ToUpperCaseAdjusterUnitTests {
	@ToUpperCase
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("To lower case")
	@Test
	public void testAdjust1() throws Exception {
		ToUpperCase annotation;
		ToUpperCaseAdjuster toUpperCaseAdjuster;
		String value;
		
		annotation = (ToUpperCase)ToUpperCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToUpperCase.class);
		toUpperCaseAdjuster = new ToUpperCaseAdjuster();
		toUpperCaseAdjuster.setAnnotation(annotation);
		value = toUpperCaseAdjuster.adjust("I hate Microsoft");
		Assertions.assertEquals("I HATE MICROSOFT", value, "To uppercase adjuster failed");
	}
    
	@DisplayName("Whitespace on start and end")
	@Test
	public void testAdjust2() throws Exception {
		ToUpperCase annotation;
		ToUpperCaseAdjuster toUpperCaseAdjuster;
		String value;
		
		annotation = (ToUpperCase)ToUpperCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToUpperCase.class);
		toUpperCaseAdjuster = new ToUpperCaseAdjuster();
		toUpperCaseAdjuster.setAnnotation(annotation);
		value = toUpperCaseAdjuster.adjust("  I hate Microsoft  ");
		// Trim only applies to the ends.  You want Apache Common Lang StringUtils.normalizeWhitespace
		Assertions.assertEquals("  I HATE MICROSOFT  ", value, "To uppercase adjuster failed");
	}
    
	@DisplayName("Only whitespace")
	@Test
	public void testAdjust3() throws Exception {
		ToUpperCase annotation;
		ToUpperCaseAdjuster toUpperCaseAdjuster;
		String value;
		
		annotation = (ToUpperCase)ToUpperCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToUpperCase.class);
		toUpperCaseAdjuster = new ToUpperCaseAdjuster();
		toUpperCaseAdjuster.setAnnotation(annotation);
		value = toUpperCaseAdjuster.adjust("     ");
		Assertions.assertEquals("     ", value, "To uppercase adjuster failed");
	}
    
}
