package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.ToLowerCase;
import name.matthewgreet.strutscommons.policy.ToLowerCaseAdjuster;

public class ToLowerCaseAdjusterUnitTests {
	@ToLowerCase
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("To lower case")
	@Test
	public void testAdjust1() throws Exception {
		ToLowerCase annotation;
		ToLowerCaseAdjuster toLowerCaseAdjuster;
		String value;
		
		annotation = (ToLowerCase)ToLowerCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToLowerCase.class);
		toLowerCaseAdjuster = new ToLowerCaseAdjuster();
		toLowerCaseAdjuster.setAnnotation(annotation);
		value = toLowerCaseAdjuster.adjust("I hate Microsoft");
		Assertions.assertEquals("i hate microsoft", value, "To lowercase adjuster failed");
	}
    
	@DisplayName("Whitespace on start and end")
	@Test
	public void testAdjust2() throws Exception {
		ToLowerCase annotation;
		ToLowerCaseAdjuster toLowerCaseAdjuster;
		String value;
		
		annotation = (ToLowerCase)ToLowerCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToLowerCase.class);
		toLowerCaseAdjuster = new ToLowerCaseAdjuster();
		toLowerCaseAdjuster.setAnnotation(annotation);
		value = toLowerCaseAdjuster.adjust("  I hate Microsoft  ");
		// Trim only applies to the ends.  You want Apache Common Lang StringUtils.normalizeWhitespace
		Assertions.assertEquals("  i hate microsoft  ", value, "To lowercase adjuster failed");
	}
    
	@DisplayName("Only whitespace")
	@Test
	public void testAdjust3() throws Exception {
		ToLowerCase annotation;
		ToLowerCaseAdjuster toLowerCaseAdjuster;
		String value;
		
		annotation = (ToLowerCase)ToLowerCaseAdjusterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ToLowerCase.class);
		toLowerCaseAdjuster = new ToLowerCaseAdjuster();
		toLowerCaseAdjuster.setAnnotation(annotation);
		value = toLowerCaseAdjuster.adjust("     ");
		Assertions.assertEquals("     ", value, "To lowercase adjuster failed");
	}
    
}
