package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.CharacterConversion;
import name.matthewgreet.strutscommons.policy.CharacterConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class CharacterConverterUnitTests {
	@CharacterConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		CharacterConversion annotation;
		CharacterConverter characterConverter;
		ConversionResult<Character> result;
		
		annotation = (CharacterConversion)CharacterConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(CharacterConversion.class);
		characterConverter = new CharacterConverter();
		characterConverter.setAnnotation(annotation);
		result = characterConverter.convert("#", Character.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(Character.valueOf('#'), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		CharacterConversion annotation;
		CharacterConverter characterConverter;
		String result;
		
		annotation = (CharacterConversion)CharacterConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(CharacterConversion.class);
		characterConverter = new CharacterConverter();
		characterConverter.setAnnotation(annotation);
		result = characterConverter.format('+');
		Assertions.assertEquals("+", result, "Final value is incorrect");
	}
    
}
