package name.matthewgreet.strutscommons.junit.policy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.policy.ByteConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class ByteConverterUnitTests {
	@ByteConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		ByteConversion annotation;
		ByteConverter byteConverter;
		ConversionResult<Byte> result;
		
		annotation = (ByteConversion)ByteConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ByteConversion.class);
		byteConverter = new ByteConverter();
		byteConverter.setAnnotation(annotation);
		result = byteConverter.convert("64", Byte.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(new Byte("64"), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		ByteConversion annotation;
		ByteConverter byteConverter;
		ConversionResult<Byte> result;
		
		annotation = (ByteConversion)ByteConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ByteConversion.class);
		byteConverter = new ByteConverter();
		byteConverter.setAnnotation(annotation);
		result = byteConverter.convert("$64", Byte.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		ByteConversion annotation;
		ByteConverter byteConverter;
		String result;
		
		annotation = (ByteConversion)ByteConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(ByteConversion.class);
		byteConverter = new ByteConverter();
		byteConverter.setAnnotation(annotation);
		result = byteConverter.format(new Byte("-75"));
		Assertions.assertEquals("-75", result, "Final value is incorrect");
	}
    
}
