package name.matthewgreet.strutscommons.junit.policy;

import java.math.BigDecimal;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import name.matthewgreet.strutscommons.annotation.BigDecimalConversion;
import name.matthewgreet.strutscommons.policy.BigDecimalConverter;
import name.matthewgreet.strutscommons.policy.ConversionResult;


public class BigDecimalConverterUnitTests {
	@BigDecimalConversion
	private boolean annotationPlaceholderDefault;
	
	
	@BeforeEach
	public void init() {
		// Empty
	}
	
	
	@DisplayName("Normal conversion")
	@Test
	public void testConvert1() throws Exception {
		BigDecimalConversion annotation;
		BigDecimalConverter bigDecimalConverter;
		ConversionResult<BigDecimal> result;
		
		annotation = (BigDecimalConversion)BigDecimalConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BigDecimalConversion.class);
		bigDecimalConverter = new BigDecimalConverter();
		bigDecimalConverter.setAnnotation(annotation);
		result = bigDecimalConverter.convert("664.67", BigDecimal.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(new BigDecimal("664.67"), result.getParsedValue(), "Final value is incorrect");
		Assertions.assertEquals(true, result.getSuccess(), "Conversion should be successful");
	}
    
	@DisplayName("Failed conversion")
	@Test
	public void testConvert2() throws Exception {
		BigDecimalConversion annotation;
		BigDecimalConverter bigDecimalConverter;
		ConversionResult<BigDecimal> result;
		
		annotation = (BigDecimalConversion)BigDecimalConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BigDecimalConversion.class);
		bigDecimalConverter = new BigDecimalConverter();
		bigDecimalConverter.setAnnotation(annotation);
		result = bigDecimalConverter.convert("$664.67", BigDecimal.class);
		Assertions.assertNotNull(result, "Converters never return null");
		Assertions.assertEquals(null, result.getMessage(), "Standard policies leave message to annotation");
		Assertions.assertEquals(null, result.getMessageKey(), "Standard policies leave message key to annotation");
		Assertions.assertEquals(null, result.getMessageType(), "Standard policies leave message type to annotation");
		Assertions.assertEquals(false, result.getSuccess(), "Conversion should have failed");
	}
    
	@DisplayName("Normal format")
	@Test
	public void testFormat1() throws Exception {
		BigDecimalConversion annotation;
		BigDecimalConverter bigDecimalConverter;
		String result;
		
		annotation = (BigDecimalConversion)BigDecimalConverterUnitTests.class.getDeclaredField("annotationPlaceholderDefault").getAnnotation(BigDecimalConversion.class);
		bigDecimalConverter = new BigDecimalConverter();
		bigDecimalConverter.setAnnotation(annotation);
		result = bigDecimalConverter.format(new BigDecimal("-775.34"));
		Assertions.assertEquals("-775.34", result, "Final value is incorrect");
	}
    
}
