package name.matthewgreet.strutscommons.util;

import java.io.Serializable;
import java.util.Collection;

/**
 * <P>Transfer Object Assembler for lazy loading additional data needed for a search results page that a base record 
 * list finder (instance of {@link ListFinder}) does not find.</P>
 * 
 * <DL>
 *   <DT>T</DT><DD>Record type.</DD>
 * </DL>
 */
@FunctionalInterface
public interface PageExtensionAssembler<T extends Serializable> extends Serializable {
    /**
     * Attaches additional data to each record for a requested page that the base record list finder did not load.   
     */
    public void assemblePageExtensions(Collection<T> items) throws Exception;
    
    /**
     * Returns true if finder eager loads any optional detail extensions of each item.  This is usually false as loading
     * extensions results in poor performance or there are no optional extensions.  
     */
    default public boolean getLoadsDetails() {
        return false;
    }
}
