package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.Regex;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class RegexValidator extends AbstractNonConversionValidatorSupport<Regex> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return getAnnotation().processNoValue();
	}

    @Override
    public ValidationResult validate(String formValue) throws Exception {
        if (formValue.matches(getAnnotation().regex())) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
