package name.matthewgreet.strutscommons.policy;

import java.lang.annotation.Annotation;
import java.util.Collection;

import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor;
import name.matthewgreet.strutscommons.interceptor.AnnotationValidationInterceptor2;



/**
 * Interface for post conversion adjusters, which alter form field values that are collections and used by 
 * {@link AnnotationValidationInterceptor2} (not {@link AnnotationValidationInterceptor}).  This is useful for adding 
 * implied values, such as midnight time for a date.  Post conversion adjusters are run after conversion but before post 
 * conversion validators.  
 */
@SuppressWarnings("deprecation")
public interface CollectionPostConversionAdjuster<A extends Annotation,T> extends Policy<A> {
    /**
     * Returns item types of recipient collection fields that can receive converted form value.  Not to be confused with 
     * collection type. 
     */
    public Class<T> getRecipientClass();
    
    /**
     * Returns whether validator should not be skipped if conversion failed or was skipped. 
     */
    public boolean getProcessNoValue();
    
    /**
     * Returns adjusted form field value. 
     */
    public Collection<T> adjust(Collection<T> formValue) throws Exception;

}
